/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.hdw.cdm;

import fxterm.core.hdw.cdm.DenominationSelection;
import fxterm.core.hdw.cdm.DenominationSelector;
import fxterm.utils.CompatUtils;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.reference.References;
import ru.softlogic.reference.hdw.BoxDescription;
import ru.softlogic.reference.hdw.CashUnitSelection;
import ru.softlogic.reference.hdw.DispenseProfile;

public class ReferencesDenominationSelector
implements DenominationSelector {
    @Override
    public DenominationSelection select(short deviceClass, int boxCount, short boxId) {
        BoxDescription key;
        CashUnitSelection selection;
        Map<BoxDescription, CashUnitSelection> prefferedCashUnits = this.getPrefferedCashUnits();
        if (prefferedCashUnits != null && (selection = prefferedCashUnits.get(key = new BoxDescription(deviceClass, boxCount, (int)boxId))) != null) {
            return new DenominationSelection(selection.getDefaultCount(), this.convert(selection.getCashUnitSet()));
        }
        return null;
    }

    private Map<BoxDescription, CashUnitSelection> getPrefferedCashUnits() {
        DispenseProfile dispenseProfile = References.getDispenseProfile();
        return dispenseProfile == null ? null : dispenseProfile.getDenominationSelector();
    }

    private Set<Denomination> convert(Set<CashUnit> set) {
        return set.stream().map(CompatUtils::convert).collect(Collectors.toSet());
    }
}

