/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.hdw.cdm;

import fxterm.app.id.LoggerId;
import fxterm.core.hdw.cdm.DenominationSelection;
import fxterm.core.hdw.cdm.DenominationSelector;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.currency.Cash;
import ru.softlogic.hardware.currency.CashProfileException;
import ru.softlogic.hardware.currency.DefaultComparator;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.currency.WrongNominalException;
import ru.softlogic.hdw.DeviceClass;

public class PropertiesDenominationSelector
implements DenominationSelector {
    private static final Logger log = LoggerId.UTILITY;
    private final Properties properties = new Properties();

    public PropertiesDenominationSelector(File file) {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            this.properties.load(fileInputStream);
        }
        catch (IOException ex) {
            log.warn((Object)ex);
        }
    }

    @Override
    public DenominationSelection select(short deviceClass, int boxCount, short boxId) {
        String key = this.buildKey(deviceClass, boxCount, boxId);
        log.info((Object)("Found denomination set by key " + key));
        String setStr = this.properties.getProperty(key + ".set");
        if (setStr == null) {
            return null;
        }
        Set<Denomination> parseDenominationSet = this.parseDenominationSet(setStr, deviceClass == 3 || deviceClass == 16 ? 0 : 1);
        String countStr = this.properties.getProperty(key + ".count");
        Integer defaultCount = this.parseDefaultCount(countStr);
        if (parseDenominationSet == null && defaultCount == null) {
            return null;
        }
        return new DenominationSelection(defaultCount == null ? 0 : defaultCount, parseDenominationSet);
    }

    private String buildKey(short deviceClass, int boxCount, short boxId) {
        return DeviceClass.getCode((short)deviceClass) + "." + boxCount + "." + boxId;
    }

    private Integer parseDefaultCount(String value) {
        try {
            if (value != null) {
                int count = Integer.parseInt(value);
                return Math.max(0, count);
            }
        }
        catch (NumberFormatException ex) {
            log.warn((Object)ex);
        }
        return null;
    }

    private Set<Denomination> parseDenominationSet(String value, int type) {
        TreeSet<Denomination> result = new TreeSet<Denomination>((Comparator<Denomination>)new DefaultComparator());
        if (value != null) {
            String[] preferred;
            for (String bill : preferred = value.split(",")) {
                try {
                    result.add(Cash.getDenomination((String)bill, (int)type));
                }
                catch (CashProfileException | WrongNominalException ex) {
                    log.warn((Object)("Wrong description " + bill));
                }
            }
        }
        return result.isEmpty() ? null : result;
    }
}

