/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.hdw.cdm;

import fxterm.app.BaseDriverFactory;
import fxterm.app.FxEnvInit;
import fxterm.app.PaylogicResources;
import fxterm.core.hdw.AppTransferListener;
import fxterm.core.hdw.CommonDeviceInfoListener;
import fxterm.core.hdw.SrvDeviceStateListener;
import fxterm.core.hdw.SrvProblemListener;
import fxterm.core.hdw.bds.BdsBoxStateListener;
import java.io.File;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.CreatingException;
import ru.softlogic.hdw.base.Device;
import ru.softlogic.hdw.dev.cashdisp.BoxStateListener;
import ru.softlogic.hdw.dev.cashdisp.CashDispenser;
import ru.softlogic.hdw.dev.cashdisp.CashDispenserDriver;
import ru.softlogic.hdw.dev.cashdisp.CashDispenserFactory;
import ru.softlogic.hdw.dev.cashdisp.CdmConfiguration;
import ru.softlogic.hdw.handling.DeviceInfoListener;
import ru.softlogic.hdw.handling.DeviceProblemListener;
import ru.softlogic.hdw.handling.DeviceStateListener;
import ru.softlogic.io.Port;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.payout.PayoutFacade;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.storage.cash.Store;
import ru.softlogic.storage.cash.StoreListener;
import ru.softlogic.storage.cash.StoreManager;
import ru.softlogic.system.util.PathUtils;

public class CdmDriverFactory
extends BaseDriverFactory {
    private CdmDriverFactory() {
    }

    public static void createBillDispenser(CdmConfiguration bdsConf, ClientInterface clientInterface, PaylogicResources resources) {
        log.info((Object)"-------------------------------------------------------------------------------");
        if (bdsConf != null && bdsConf.getOptions() != null) {
            if (bdsConf.isEnable()) {
                log.info((Object)("Try to create bill dispenser, type=" + bdsConf.getType() + ", port=" + bdsConf.getPort() + ",profile=" + bdsConf.getOptions()));
                try {
                    Logger l = CdmDriverFactory.createLogger("bill-disp", "disp/bill");
                    CashDispenserDriver cdd = CashDispenserFactory.createBillDriver((String)bdsConf.getType(), (SerialPort)bdsConf.getPort(), (File)PathUtils.getFilePath((String)"/data/disp/bill/"), (Logger)l);
                    log.info((Object)("Driver create successfully and contains " + cdd.getThreads().size() + " thread(s)"));
                    CashDispenser cd = cdd.getDispenser();
                    cd.addDeviceProblemListener((DeviceProblemListener)new SrvProblemListener(clientInterface));
                    cd.addDeviceInfoListener((DeviceInfoListener)new CommonDeviceInfoListener(clientInterface));
                    cd.addStateListener((DeviceStateListener)new SrvDeviceStateListener(clientInterface));
                    cd.addBoxStateListener((BoxStateListener)new BdsBoxStateListener(clientInterface, 16));
                    cd.getStore().addListener((StoreListener)new AppTransferListener(cd.getDeviceId(), clientInterface));
                    FxEnvInit.setBillDispenser(cd);
                    resources.getThreads().addAll(cdd.getThreads());
                    CdmDriverFactory.setSensorListener((Device)cd, clientInterface);
                    StoreManager.registerStore((short)16, (Store)cd.getStore());
                    PayoutFacade.registerDevice((CashDispenser)cd, (int)40);
                }
                catch (CreatingException ex) {
                    CdmDriverFactory.onCreatingError(clientInterface, (short)16, bdsConf.getType(), (Port)bdsConf.getPort(), (Exception)((Object)ex));
                }
            } else {
                log.info((Object)"Bill dispenser is not active");
            }
        } else {
            log.info((Object)"Bill dispenser section or options is not found");
        }
    }

    public static void createCoinDispenser(CdmConfiguration bdsConf, ClientInterface clientInterface, PaylogicResources resources) {
        log.info((Object)"-------------------------------------------------------------------------------");
        if (bdsConf != null && bdsConf.getOptions() != null) {
            if (bdsConf.isEnable()) {
                log.info((Object)("Try to create coin dispenser, type=" + bdsConf.getType() + ", port=" + bdsConf.getPort() + ",profile=" + bdsConf.getOptions()));
                try {
                    Logger l = CdmDriverFactory.createLogger("coin-disp", "disp/coin");
                    CashDispenserDriver cdd = CashDispenserFactory.createCoinDriver((String)bdsConf.getType(), (SerialPort)bdsConf.getPort(), (File)PathUtils.getFilePath((String)"/data/disp/coin/"), (Logger)l);
                    log.info((Object)("Driver create successfully and contains " + cdd.getThreads().size() + " thread(s)"));
                    CashDispenser cd = cdd.getDispenser();
                    cd.addDeviceProblemListener((DeviceProblemListener)new SrvProblemListener(clientInterface));
                    cd.addDeviceInfoListener((DeviceInfoListener)new CommonDeviceInfoListener(clientInterface));
                    cd.addStateListener((DeviceStateListener)new SrvDeviceStateListener(clientInterface));
                    cd.addBoxStateListener((BoxStateListener)new BdsBoxStateListener(clientInterface, 18));
                    cd.getStore().addListener((StoreListener)new AppTransferListener(cd.getDeviceId(), clientInterface));
                    FxEnvInit.setCoinDispenser(cd);
                    resources.getThreads().addAll(cdd.getThreads());
                    CdmDriverFactory.setSensorListener((Device)cd, clientInterface);
                    StoreManager.registerStore((short)18, (Store)cd.getStore());
                    PayoutFacade.registerDevice((CashDispenser)cd, (int)80);
                }
                catch (CreatingException ex) {
                    CdmDriverFactory.onCreatingError(clientInterface, (short)18, bdsConf.getType(), (Port)bdsConf.getPort(), (Exception)((Object)ex));
                }
            } else {
                log.info((Object)"Bill dispenser is not active");
            }
        } else {
            log.info((Object)"Bill dispenser section or options is not found");
        }
    }
}

