/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.hdw.bvr.oper;

import fxterm.app.id.LoggerId;
import fxterm.core.hdw.bvr.oper.BaseCashInOperation;
import fxterm.core.hdw.bvr.oper.NewKeeper2;
import fxterm.core.hdw.bvr.oper.SumLimits;
import fxterm.session.Session;
import fxterm.utils.CompatUtils;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.hardware.currency.Cash;
import ru.softlogic.hardware.currency.CashProfileException;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.currency.Sum;
import ru.softlogic.hardware.currency.WrongNominalException;
import ru.softlogic.reference.service.Service;

public class OperationFactory {
    private static final Logger log = LoggerId.PAY;

    private OperationFactory() {
    }

    public static BaseCashInOperation createDefaultOperation(NewKeeper2 keeper, SumLimits limits, String token) {
        log.info((Object)("Create operation with keeper sum=" + keeper.getInSumTotal() + ", limits=" + limits));
        HashSet<Integer> ids = new HashSet<Integer>();
        for (CashUnit cu : Session.getAllowedNotes()) {
            ids.add(cu.getId());
        }
        for (CashUnit cu : Session.getAllowedCoins()) {
            ids.add(cu.getId());
        }
        Service s = Session.getService();
        ru.softlogic.cash.Sum minFirstBill = null;
        if (OperationFactory.isSet(limits.getMinSumWithNoteLimit())) {
            minFirstBill = limits.getMinSumWithNoteLimit();
        } else if (s.isFirstBillEqualsMinSum()) {
            minFirstBill = s.getMinSum();
        }
        log.info((Object)("Minimum denomination of the first bill: " + minFirstBill));
        return new BaseCashInOperation(keeper, limits.getMaxSum(), limits.getMaxSum(), minFirstBill, ids, null, token);
    }

    public static BaseCashInOperation createDefaultOperation(NewKeeper2 keeper, Sum max, String token) {
        return OperationFactory.createDefaultOperation(keeper, new SumLimits(CompatUtils.convertNull(max)), token);
    }

    private static Set<Denomination> getDenominations(String curr) {
        HashSet<CashUnit> units = new HashSet<CashUnit>();
        units.addAll(Session.getAllowedNotes());
        units.addAll(Session.getAllowedCoins());
        HashSet<Denomination> res = new HashSet<Denomination>();
        for (CashUnit cu : units) {
            try {
                res.add(Cash.getDenomination((String)curr, (int)cu.getNominal().getValue(), (int)(cu.getType() == 3 ? 0 : 1)));
            }
            catch (CashProfileException | WrongNominalException ex) {
                log.error((Object)("Error on convert bill: " + ex.getMessage()));
            }
        }
        return res;
    }

    private static ru.softlogic.cash.Sum getMaxSum(Service s) {
        ru.softlogic.cash.Sum max = s.getMaxInputSum();
        if (max == null || max.isEmpty()) {
            max = s.getMaxSum();
        }
        return max;
    }

    private static boolean isSet(ru.softlogic.cash.Sum sum) {
        return sum != null && !sum.isEmpty();
    }
}

