/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.hdw.bvr.oper;

import fxterm.core.hdw.bvr.oper.ActivatedCashBackCard;
import fxterm.core.hdw.bvr.oper.IssuedCashBackCard;
import fxterm.core.hdw.bvr.oper.NewKeeperListener;
import fxterm.utils.CompatUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.currency.set.DenominationSet;
import ru.softlogic.storage.cash.BoxId;

public class NewKeeper2
implements Serializable,
Cloneable {
    public static final BoxId VIRTUAL_BOX = new BoxId(100, 0, 0);
    private static final long serialVersionUID = 6332539380833522393L;
    private String currency;
    private Sum in;
    private final Map<CashUnit, Integer> accepted = new HashMap<CashUnit, Integer>();
    private Map<BoxId, DenominationSet> acceptedCash = new HashMap<BoxId, DenominationSet>();
    private final Map<CashUnit, Integer> dispensed = new HashMap<CashUnit, Integer>();
    private Map<BoxId, DenominationSet> dispensedCash = new HashMap<BoxId, DenominationSet>();
    private final List<ActivatedCashBackCard> activatedCards = new LinkedList<ActivatedCashBackCard>();
    private IssuedCashBackCard issuedCard;
    private Sum out;
    private transient NewKeeperListener listener;

    public NewKeeper2(String currency) {
        this(currency, new Sum(0, currency));
    }

    public NewKeeper2(String currency, Sum in) {
        this.currency = Objects.requireNonNull(currency, "Currency is null");
        this.in = Objects.requireNonNull(in, "In sum is null");
        this.check(in);
    }

    public NewKeeper2(NewKeeper2 keeper) {
        this.currency = keeper.currency;
        this.activatedCards.addAll(keeper.getInputCards());
        this.acceptedCash.putAll(keeper.getInputCash());
        this.dispensedCash.putAll(keeper.getOutputCash());
        this.accepted.putAll(keeper.getInputMap());
        this.dispensed.putAll(keeper.getOutputMap());
        this.in = new Sum(keeper.getIncome());
        this.out = new Sum(keeper.getOut());
        IssuedCashBackCard icbc = keeper.getIssuedCard();
        if (icbc != null) {
            this.issuedCard = new IssuedCashBackCard(icbc.getPincode(), icbc.getNominal());
        }
    }

    public String getCurrency() {
        return this.currency;
    }

    public Sum getIncome() {
        return this.in;
    }

    public void setIncome(Sum in) {
        this.in = in;
    }

    public void addIn(BoxId boxId, Denomination cashUnit) {
        this.addIn(boxId, cashUnit, 1);
    }

    public void addIn(BoxId boxId, Denomination denomination, int count) {
        this.check(denomination);
        if (count <= 0) {
            throw new IllegalArgumentException("Count must be positive");
        }
        DenominationSet den = this.acceptedCash.getOrDefault(boxId, new DenominationSet());
        den.add(denomination, count);
        this.acceptedCash.put(boxId, den);
        this.onUpdate();
    }

    public void add(ActivatedCashBackCard ncbc) {
        this.check(ncbc.getNominal());
        this.activatedCards.add(ncbc);
        this.onUpdate();
    }

    public void setIssuedCard(IssuedCashBackCard issuedCard) {
        this.check(issuedCard.getNominal());
        this.issuedCard = issuedCard;
        this.onUpdate();
    }

    public void addDispensed(BoxId boxId, DenominationSet denominations) {
        Objects.requireNonNull(boxId, "BoxId is null");
        Objects.requireNonNull(denominations, "DenominationSet require");
        if (!denominations.isEmpty()) {
            DenominationSet denSet = this.dispensedCash.getOrDefault(boxId, new DenominationSet());
            denSet.add(denominations);
            this.dispensedCash.put(boxId, denSet);
            this.onUpdate();
        }
    }

    public void setSumOut(Sum sum) {
        if (Objects.equals(this.out, sum)) {
            return;
        }
        this.check(sum);
        this.out = sum;
        this.onUpdate();
    }

    public Sum getOut() {
        return this.out;
    }

    public Sum getInSumTotal() {
        return this.getInCashSum().add(this.getInCashlessSum());
    }

    public Sum getInCashSum() {
        return this.caclTotal(this.acceptedCash, this.currency);
    }

    public Sum getInCashlessSum() {
        int sum = this.in.getValue();
        for (ActivatedCashBackCard ncbc : this.activatedCards) {
            sum += ncbc.getNominal().getValue();
        }
        return new Sum(sum, this.currency);
    }

    public Sum getOutSumTotal() {
        return this.getOutCashSum().add(this.getOutCashlessSum());
    }

    public Sum getOutCashSum() {
        return this.caclTotal(this.dispensedCash, this.currency);
    }

    private Sum caclTotal(Map<BoxId, DenominationSet> map, String currency) {
        if (map.isEmpty()) {
            return new Sum(0, currency);
        }
        return map.values().stream().map(set -> set.getTotal(currency)).reduce((s1, s2) -> s1.add(s2)).map(CompatUtils::convert).get();
    }

    public Sum getOutCashlessSum() {
        Sum cardSum = this.issuedCard == null ? new Sum(0, this.currency) : this.issuedCard.getNominal();
        return cardSum.add(this.out == null ? new Sum(0, this.currency) : this.out);
    }

    public Sum getSum() {
        return this.getInSumTotal().sub(this.getOutSumTotal());
    }

    public Map<CashUnit, Integer> getInputMap() {
        return Collections.unmodifiableMap(this.accepted);
    }

    public Map<CashUnit, Integer> getOutputMap() {
        return Collections.unmodifiableMap(this.dispensed);
    }

    public Map<BoxId, DenominationSet> getInputCash() {
        return Collections.unmodifiableMap(this.acceptedCash);
    }

    public Map<BoxId, DenominationSet> getOutputCash() {
        return Collections.unmodifiableMap(this.dispensedCash);
    }

    public List<ActivatedCashBackCard> getInputCards() {
        return Collections.unmodifiableList(this.activatedCards);
    }

    public IssuedCashBackCard getIssuedCard() {
        return this.issuedCard;
    }

    public boolean isEmpty() {
        return this.isInEmpty() && this.isOutEmpty();
    }

    public boolean isInEmpty() {
        return this.in.isEmpty() && this.acceptedCash.isEmpty() && this.activatedCards.isEmpty() && this.accepted.isEmpty();
    }

    public boolean isOutEmpty() {
        return this.dispensedCash.isEmpty() && (this.issuedCard == null || this.issuedCard.getNominal().isEmpty()) && this.dispensed.isEmpty();
    }

    private void check(CashUnit cu) {
        this.check(cu.getNominal());
    }

    private void check(Denomination cu) {
        this.check(new Sum(cu.getNominal(), cu.getCurrency()));
    }

    private void check(Sum sum) {
        if (!this.currency.equals(sum.getCurrency())) {
            if (!this.isEmpty()) {
                throw new IllegalArgumentException("Wrong currency, expected " + this.currency + ", obtained: " + sum.getCurrency());
            }
            this.setIncome(new Sum(0, sum.getCurrency()));
            this.reset();
        }
    }

    public void reset() {
        this.reset(this.in.getCurrency());
    }

    public void reset(String currency) {
        Sum s0 = new Sum(0, currency);
        this.currency = currency;
        this.in = s0;
        this.out = s0;
        this.resetCardAndCashInfo();
        this.onUpdate();
    }

    public void resetCardAndCashInfo() {
        this.issuedCard = null;
        this.acceptedCash.clear();
        this.activatedCards.clear();
        this.dispensedCash.clear();
    }

    public void setListener(NewKeeperListener listener) {
        this.listener = listener;
    }

    private void onUpdate() {
        if (this.listener != null) {
            this.listener.onUpdate();
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.acceptedCash == null) {
            this.acceptedCash = new HashMap<BoxId, DenominationSet>();
        }
        if (this.dispensedCash == null) {
            this.dispensedCash = new HashMap<BoxId, DenominationSet>();
        }
    }

    public String toString() {
        return "NewKeeper2{  currency=" + this.currency + ", in=" + this.in + ", accepted=" + this.acceptedCash + ", activatedCards=" + this.activatedCards + ", dispensed=" + this.dispensedCash + ", issuedCard=" + this.issuedCard + ", out=" + this.out + '}';
    }
}

