/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.hdw.bvr.oper;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashUnit;

public class CashSet {
    private final String currency;
    private final Map<CashUnit, Integer> set;

    public CashSet(String currency) {
        this(currency, new HashMap<CashUnit, Integer>());
    }

    public CashSet(String currency, Map<CashUnit, Integer> set) {
        this.currency = currency;
        this.set = set;
    }

    public String getCurrency() {
        return this.currency;
    }

    public Map<CashUnit, Integer> getCashSet() {
        return Collections.unmodifiableMap(this.set);
    }

    public Sum getTotal() {
        int res = 0;
        for (CashUnit cu : this.set.keySet()) {
            res += cu.getNominal().getValue() * this.set.getOrDefault(cu, 0);
        }
        return new Sum(res, this.currency);
    }
}

