/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.hdw.bvr.oper;

import fxterm.app.id.LoggerId;
import fxterm.core.AppSumFormatter;
import fxterm.core.hdw.bvr.oper.ActivatedCashBackCard;
import fxterm.core.hdw.bvr.oper.FraudListener;
import fxterm.core.hdw.bvr.oper.NewKeeper2;
import fxterm.utils.CompatUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.currency.Sum;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.dev.cashacc.CashInOperation;
import ru.softlogic.hdw.dev.cashacc.CashInOperationListener;
import ru.softlogic.hdw.handling.HdwMsg;
import ru.softlogic.storage.cash.BoxId;

public class BaseCashInOperation
implements CashInOperation {
    private static final short DEFAULT_BOX_ID = 0;
    private static final Logger log = LoggerId.PAY;
    private final NewKeeper2 keeper;
    private final ru.softlogic.cash.Sum max1;
    private final ru.softlogic.cash.Sum max2;
    private final ru.softlogic.cash.Sum firstMinNominal;
    private final Set<Integer> allowed;
    private final Set<Integer> sVerify;
    private boolean enable = true;
    private String token;
    private final Set<CashInOperationListener> opListeners = new HashSet<CashInOperationListener>();
    private final Set<FraudListener> frListeners = new HashSet<FraudListener>();
    private final Map<Integer, Integer> fraudData = new ConcurrentHashMap<Integer, Integer>();
    private static final Map<Integer, Float> fraudWeights = new HashMap<Integer, Float>();

    public BaseCashInOperation(NewKeeper2 keeper, ru.softlogic.cash.Sum max1, ru.softlogic.cash.Sum max2, ru.softlogic.cash.Sum firstMinNominal, Set<Integer> allowed, Set<Integer> sVerify, String token) {
        if (keeper == null) {
            throw new NullPointerException("Keeper is null");
        }
        this.max1 = max1;
        this.max2 = max2;
        this.firstMinNominal = firstMinNominal;
        this.allowed = allowed;
        this.sVerify = sVerify;
        this.keeper = keeper;
        this.token = token;
    }

    public static float getFraudWeight(int fraudMarker) {
        return fraudWeights.getOrDefault(fraudMarker, Float.valueOf(0.0f)).floatValue();
    }

    public boolean canAccept(DeviceId did, Denomination denomination) {
        if (!this.enable) {
            log.info((Object)"REJECTED: operation is disabled");
            return false;
        }
        if (denomination == null) {
            log.info((Object)"REJECTED: denomination is null");
            return false;
        }
        if (!this.keeper.getCurrency().equals(denomination.getCurrency())) {
            log.info((Object)("REJECTED: Wrong currency, expect: " + this.keeper.getCurrency() + ", obtained: " + denomination.getCurrency()));
            return false;
        }
        if (this.allowed != null && !this.allowed.contains(denomination.getId())) {
            log.info((Object)("REJECTED: " + denomination + " not in the list of bills. Allowed: " + this.allowed));
            return false;
        }
        if (this.firstMinNominal != null && this.keeper.isEmpty() && denomination.getNominal() < this.firstMinNominal.getValue()) {
            log.info((Object)("REJECTED: " + denomination + " - first bill is less than the authorized nominal " + this.firstMinNominal));
            return false;
        }
        ru.softlogic.cash.Sum rest = this._getAllowedSum();
        if (rest != null && denomination.getNominal() > rest.getValue()) {
            log.info((Object)("REJECTED: Sum is too high, sum allowed: " + rest));
            return false;
        }
        return true;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        if (this.enable != enable) {
            log.info((Object)("Change state, enable: " + enable));
        }
        this.enable = enable;
    }

    public Sum getAllowedSum() {
        return CompatUtils.convertNull(this._getAllowedSum());
    }

    public String getCurrency() {
        return this.keeper.getCurrency();
    }

    public boolean isStrongVerify(Denomination denomination) {
        this.check(denomination);
        return this.sVerify != null && this.sVerify.contains(denomination.getId());
    }

    private ru.softlogic.cash.Sum _getAllowedSum() {
        ru.softlogic.cash.Sum acc = this.getSum();
        if (this.max1 != null && this.max1.compareTo(acc) <= 0) {
            return new ru.softlogic.cash.Sum(0, this.keeper.getCurrency());
        }
        if (this.max2 == null) {
            return null;
        }
        if (this.max2.compareTo(acc) > 0) {
            return this.max2.sub(acc);
        }
        return new ru.softlogic.cash.Sum(0, this.keeper.getCurrency());
    }

    public final synchronized void onAccept(DeviceId did, Denomination denomination) {
        Objects.requireNonNull(denomination, "Denomination is null");
        BoxId boxId = new BoxId(denomination.getType() == 0 ? (short)3 : 4, did.getNumber(), 0);
        this.keeper.addIn(boxId, denomination);
        log.info((Object)("Accept: " + denomination + ", total: " + AppSumFormatter.asStr(this.getSum()) + ", allowed: " + AppSumFormatter.asStr((Sum)this.getAllowedSum()) + ", device: " + did));
        this.notifyOpListeners();
    }

    public synchronized void add(ActivatedCashBackCard acbc) {
        this.keeper.add(acbc);
        log.info((Object)("Accept: " + acbc + ", total: " + AppSumFormatter.asStr(this.getSum()) + ", allowed: " + AppSumFormatter.asStr((Sum)this.getAllowedSum())));
        this.notifyOpListeners();
    }

    public ru.softlogic.cash.Sum getSum() {
        return this.keeper.getInSumTotal();
    }

    public NewKeeper2 getKeeper() {
        return this.keeper;
    }

    public Map<Integer, Integer> getFraudData() {
        return Collections.unmodifiableMap(this.fraudData);
    }

    public void onFraudMarker(int markerId) {
        log.info((Object)("Get fraud marker, id: " + markerId + ", " + HdwMsg.getFraudMarker((int)markerId)));
        this.fraudData.put(markerId, this.fraudData.getOrDefault(markerId, 0) + 1);
        log.info((Object)"Fraud map:");
        for (int mid : this.fraudData.keySet()) {
            log.info((Object)("    " + HdwMsg.getFraudMarker((int)mid) + "->" + this.fraudData.get(mid)));
        }
        log.info((Object)"----");
        this.notifyFrListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOperationListener(CashInOperationListener listener) {
        this.check(listener);
        Set<CashInOperationListener> set = this.opListeners;
        synchronized (set) {
            this.opListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOperationListener(CashInOperationListener listener) {
        this.check(listener);
        Set<CashInOperationListener> set = this.opListeners;
        synchronized (set) {
            this.opListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFraudListener(FraudListener listener) {
        this.check(listener);
        Set<FraudListener> set = this.frListeners;
        synchronized (set) {
            this.frListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFraudListener(FraudListener listener) {
        this.check(listener);
        Set<FraudListener> set = this.frListeners;
        synchronized (set) {
            this.frListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyOpListeners() {
        Set<CashInOperationListener> set = this.opListeners;
        synchronized (set) {
            for (CashInOperationListener ciol : this.opListeners) {
                ciol.onChangeKeeper();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyFrListeners() {
        Set<FraudListener> set = this.frListeners;
        synchronized (set) {
            for (FraudListener fl : this.frListeners) {
                fl.onFraudAttempt();
            }
        }
    }

    private void check(CashInOperationListener listener) {
        if (listener == null) {
            throw new NullPointerException("CashInOperationListener is null");
        }
    }

    private void check(FraudListener listener) {
        if (listener == null) {
            throw new NullPointerException("FraudListener is null");
        }
    }

    private void check(Denomination dn) {
        if (dn == null) {
            throw new NullPointerException("Denomination is null");
        }
    }

    public String getToken() {
        return this.token;
    }

    static {
        fraudWeights.put(0, Float.valueOf(0.95f));
        fraudWeights.put(1, Float.valueOf(1.0f));
        fraudWeights.put(3, Float.valueOf(0.05f));
        fraudWeights.put(2, Float.valueOf(0.05f));
        fraudWeights.put(4, Float.valueOf(1.0f));
    }
}

