/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.hdw.bvr.col;

import fxterm.app.FxEnv;
import fxterm.app.SystemProp;
import fxterm.app.id.LoggerId;
import fxterm.core.Sequence;
import fxterm.core.hdw.bvr.col.CashCollection;
import fxterm.core.hdw.bvr.col.CollectionHelper;
import fxterm.core.hdw.prt.PrnUtils;
import fxterm.utils.CompatUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import plfx.GuiNotifier;
import plfx.shell2.dialog.Dialog;
import ru.softlogic.cash.BoxId;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.currency.set.DenominationSet;
import ru.softlogic.hdw.DeviceClass;
import ru.softlogic.reference.References;
import ru.softlogic.reference.point.PointOptions;
import ru.softlogic.reference.point.ServerUser;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.srv.api.oth.MoneyCollection;
import ru.softlogic.storage.cash.Box;
import ru.softlogic.storage.cash.BoxNotFoundException;
import ru.softlogic.storage.cash.Collection;
import ru.softlogic.storage.cash.StoreManager;
import ru.softlogic.storage.cash.WrongOperationException;

abstract class UtilityHandler {
    private static final Logger log = LoggerId.APP;

    UtilityHandler() {
    }

    protected abstract void next(ru.softlogic.storage.cash.BoxId var1);

    public void makeCollection(ru.softlogic.storage.cash.BoxId operId, ru.softlogic.storage.cash.BoxId initId, ServerUser user) {
        try {
            UtilityHandler.makeCollection(operId, user);
            this.next(initId);
        }
        catch (BoxNotFoundException | WrongOperationException ex) {
            GuiNotifier.notifyError((String)ex.getMessage());
            Dialog.show((String)"common/error", actionId -> this.next(initId));
        }
    }

    protected static void sendEvent(EventType type, ru.softlogic.storage.cash.BoxId id) {
        FxEnv.getConnector().sendEvent(new Event[]{new Event(type, DeviceClass.asStr((short)id.getDeviceClass()) + "|" + id.getDeviceNumber() + "|" + id.getBoxNumber())});
    }

    public static synchronized void makeCollection(ru.softlogic.storage.cash.BoxId operId, ServerUser user) throws BoxNotFoundException, WrongOperationException {
        log.info((Object)"Make collection");
        UtilityHandler.sendEvent(EventType.MoneyCollection, operId);
        Box box = StoreManager.getBox((ru.softlogic.storage.cash.BoxId)operId);
        Collection cl = box.empty();
        log.info((Object)("Content: " + cl));
        int collectionId = Sequence.getCollectionId();
        FxEnv.getPrintSpooler().print(PrnUtils.createPrinterJob(new CashCollection(collectionId, cl.getLastEmpty(), new Date(), new DenominationSet(cl.getCounts()), operId, user, 0)));
        BoxId boxid = CollectionHelper.convert(operId);
        FxEnv.getConnector().sendMoneyCollection(new MoneyCollection(collectionId, cl.getLastEmpty(), new Date(), CompatUtils.convert(boxid, cl.getCounts()), boxid, user, 0));
    }

    public static synchronized void makeCollection(List<ru.softlogic.storage.cash.BoxId> boxIds, ServerUser user) throws BoxNotFoundException, WrongOperationException {
        log.info((Object)"Make collection");
        ArrayList<CashCollection> collections = new ArrayList<CashCollection>();
        for (ru.softlogic.storage.cash.BoxId boxId : boxIds) {
            UtilityHandler.sendEvent(EventType.MoneyCollection, boxId);
            Box box = StoreManager.getBox((ru.softlogic.storage.cash.BoxId)boxId);
            Collection cl = box.empty();
            log.info((Object)("Content: " + cl));
            int collectionId = Sequence.getCollectionId();
            collections.add(new CashCollection(collectionId, cl.getLastEmpty(), new Date(), new DenominationSet(cl.getCounts()), boxId, user, 0));
            BoxId boxid = CollectionHelper.convert(boxId);
            FxEnv.getConnector().sendMoneyCollection(new MoneyCollection(collectionId, cl.getLastEmpty(), new Date(), CompatUtils.convert(boxid, cl.getCounts()), boxid, user, 0));
        }
        if (collections.isEmpty()) {
            log.warn((Object)"Empty multi collection");
        } else {
            FxEnv.getPrintSpooler().print(PrnUtils.createPrinterJob(collections));
        }
    }

    public static synchronized void makeRefill(ru.softlogic.storage.cash.BoxId operId, ServerUser user, Map<Denomination, Integer> counts) throws BoxNotFoundException, WrongOperationException {
        log.info((Object)"Make refill");
        UtilityHandler.sendEvent(EventType.MoneyCollection, operId);
        Box box = StoreManager.getBox((ru.softlogic.storage.cash.BoxId)operId);
        Date lastRefill = box.getLastRefill();
        box.refill(counts);
        int collectionId = Sequence.getCollectionId();
        FxEnv.getPrintSpooler().print(PrnUtils.createPrinterJob(new CashCollection(collectionId, lastRefill, new Date(), new DenominationSet(counts), operId, user, 1)));
        BoxId boxid = new BoxId(operId.getDeviceClass(), operId.getDeviceNumber(), operId.getBoxNumber());
        FxEnv.getConnector().sendMoneyCollection(new MoneyCollection(collectionId, lastRefill, new Date(), CompatUtils.convert(boxid, counts), boxid, user, 1));
    }

    protected int getCollectionStrategy() {
        PointOptions po = References.getPointOptions();
        if (po != null) {
            return po.getCollectionStrategy2();
        }
        return 0;
    }

    protected boolean isMakeAction(int actionId) {
        return actionId == 0 || actionId == -1 && SystemProp.isAutoCollection();
    }

    protected boolean hasFlag(int flag) {
        return (this.getCollectionStrategy() & flag) != 0;
    }
}

