/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.hdw.bvr.col;

import fxterm.app.id.LoggerId;
import fxterm.core.hdw.bvr.col.BillCollectionHandler;
import fxterm.core.hdw.bvr.col.CoinCollectionHandler;
import fxterm.core.hdw.bvr.col.CollectionException;
import fxterm.core.hdw.bvr.col.CollectionRequest;
import fxterm.core.hdw.bvr.col.ConsoleHandler;
import fxterm.core.hdw.bvr.col.Handler;
import fxterm.core.hdw.bvr.col.MultiCollectionRequest;
import fxterm.core.hdw.bvr.col.UtilityHandler;
import fxterm.core.hdw.bvr.col.Waiter;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import plfx.util.TerminalPlatform;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.storage.cash.BoxId;
import ru.softlogic.storage.cash.BoxNotFoundException;
import ru.softlogic.storage.cash.WrongOperationException;

public class CollectionQueue {
    private static Thread th;
    private static final BlockingQueue<BoxId> reqs;
    private static final Logger log;
    private static Handler handler;
    private static Waiter waiter;

    private CollectionQueue() {
    }

    public static void addCollection(BoxId boxId) {
        if (th == null) {
            CollectionQueue.init();
        }
        log.info((Object)("Add collection request: " + boxId));
        reqs.add(boxId);
    }

    public static void makeCollection(CollectionRequest request) throws CollectionException {
        log.info((Object)("Make collection: " + request));
        try {
            UtilityHandler.makeCollection(request.getBoxId(), request.getUser());
        }
        catch (BoxNotFoundException | WrongOperationException ex) {
            throw new CollectionException("Erron on process collection", ex);
        }
    }

    public static void makeCollection(MultiCollectionRequest request) throws CollectionException {
        log.info((Object)("Make collection: " + request));
        try {
            UtilityHandler.makeCollection(request.getBoxIds(), request.getUser());
        }
        catch (BoxNotFoundException | WrongOperationException ex) {
            throw new CollectionException("Erron on process collection", ex);
        }
    }

    public static void makeRefill(CollectionRequest request, Map<Denomination, Integer> counts) throws CollectionException {
        log.info((Object)("Make collection: " + request));
        try {
            UtilityHandler.makeRefill(request.getBoxId(), request.getUser(), counts);
        }
        catch (BoxNotFoundException | WrongOperationException ex) {
            throw new CollectionException("Erron on process collection", ex);
        }
    }

    private static synchronized void init() {
        if (th == null) {
            waiter = new Waiter();
            handler = new BillCollectionHandler(new CoinCollectionHandler(new ConsoleHandler(waiter, log), log), log);
            th = new Thread((Runnable)new LocaRunnable(), "CollectionQueue");
            th.setDaemon(true);
            th.start();
        }
    }

    static {
        reqs = new LinkedBlockingQueue<BoxId>();
        log = LoggerId.APP;
    }

    private static class LocaRunnable
    implements Runnable {
        private LocaRunnable() {
        }

        @Override
        public void run() {
            log.info((Object)"Start thread");
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    log.info((Object)"Wait next collection request");
                    BoxId request = (BoxId)reqs.take();
                    waiter.reinit();
                    TerminalPlatform.runLater(() -> handler.process(request));
                    log.info((Object)"Wait for end");
                    waiter.waitForFinish();
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            log.info((Object)"Stop thread");
        }
    }
}

