/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.hdw.bvr.col;

import fxterm.core.hdw.bvr.col.CashCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.softlogic.cash.BoxId;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.currency.set.DenominationSet;
import ru.softlogic.srv.api.oth.MoneyCollection;
import ru.softlogic.storage.cash.Box;

public class CollectionHelper {
    public static CashCollection convert(MoneyCollection mc) {
        CashCollection cc = new CashCollection(mc.getId(), mc.getLastDate(), mc.getDate(), CollectionHelper.convert(mc.getKeeper().getCashUnits()), new ru.softlogic.storage.cash.BoxId(mc.getDeviceClass(), mc.getDeviceNum(), mc.getBoxNum()), mc.getMenuUser(), mc.getType());
        return cc;
    }

    public static DenominationSet convert(Map<CashUnit, Integer> cus) {
        HashMap m = new HashMap();
        cus.forEach((cu, i) -> m.put(CollectionHelper.convert(cu), i));
        return new DenominationSet(m);
    }

    public static Denomination convert(CashUnit cu) {
        return new Denomination(cu.getId(), cu.getType() == 4 ? 1 : 0, cu.getNominal().getValue(), cu.getNominal().getCurrency());
    }

    public static List<ru.softlogic.storage.cash.BoxId> convert(Box[] boxes, short deviceClass) {
        ArrayList<ru.softlogic.storage.cash.BoxId> res = new ArrayList<ru.softlogic.storage.cash.BoxId>();
        for (Box box : boxes) {
            res.add(new ru.softlogic.storage.cash.BoxId(deviceClass, box.getId()));
        }
        return res;
    }

    public static BoxId convert(ru.softlogic.storage.cash.BoxId boxId) {
        return new BoxId(boxId.getDeviceClass(), boxId.getDeviceNumber(), boxId.getBoxNumber());
    }
}

