/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.hdw.bvr.col;

import fxterm.app.FxEnv;
import fxterm.app.SystemProp;
import fxterm.core.hdw.bvr.col.CollectionRequest;
import fxterm.core.hdw.bvr.col.Handler;
import fxterm.core.hdw.bvr.col.UtilityHandler;
import org.apache.log4j.Logger;
import plfx.shell2.dialog.Dialog;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.storage.cash.Box;
import ru.softlogic.storage.cash.BoxId;
import ru.softlogic.storage.cash.BoxNotFoundException;
import ru.softlogic.storage.cash.StoreManager;

class CoinCollectionHandler
extends UtilityHandler
implements Handler {
    private final Handler next;
    private final Logger log;

    public CoinCollectionHandler(Handler next, Logger log) {
        this.next = next;
        this.log = log;
    }

    @Override
    protected void next(BoxId request) {
        this.next.process(request);
    }

    @Override
    public void process(BoxId request) {
        this.log.info((Object)"Process coin collection");
        try {
            Box b = StoreManager.getBox((BoxId)CollectionRequest.DEFAULT_COIN_BOX);
            if (this.hasFlag(4) && (!b.isEmpty() || FxEnv.getCoinValidator() != null)) {
                if (this.hasFlag(8)) {
                    this.log.info((Object)"Ask a question");
                    Dialog.show((String)"action/stackout/collect_coin", actionId -> {
                        if (actionId == 0 || actionId == -1 && SystemProp.isAutoCollection()) {
                            this.makeCollection(CollectionRequest.DEFAULT_COIN_BOX, request, null);
                        } else {
                            this.log.info((Object)"User skip this action");
                            CoinCollectionHandler.sendEvent(EventType.VoidMoneyCollection, CollectionRequest.DEFAULT_COIN_BOX);
                            this.next(request);
                        }
                    });
                } else {
                    this.makeCollection(CollectionRequest.DEFAULT_COIN_BOX, request, null);
                }
            } else {
                this.log.info((Object)"Disabled or nothing to do, skip this step");
                this.next(request);
            }
        }
        catch (BoxNotFoundException ex) {
            this.log.info((Object)"Error on obtain coin box", (Throwable)ex);
            this.next(request);
        }
    }
}

