/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.hdw.bvr.col;

import fxterm.app.FxEnv;
import fxterm.app.SystemProp;
import fxterm.core.hdw.bvr.col.CollectionRequest;
import fxterm.core.hdw.bvr.col.Handler;
import fxterm.core.hdw.bvr.col.UtilityHandler;
import fxterm.session.Session;
import fxterm.session.SumFormatter;
import fxterm.utils.FinUtils;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import plfx.shell2.dialog.Dialog;
import ru.softlogic.cash.Sum;
import ru.softlogic.hdw.base.Device;
import ru.softlogic.hdw.dev.cashacc.CashAcceptorDevice;
import ru.softlogic.hdw.dev.printer.PrintSpooler;
import ru.softlogic.hdw.handling.DeviceState;
import ru.softlogic.hdw.handling.HdwMsg;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.storage.cash.Box;
import ru.softlogic.storage.cash.BoxId;
import ru.softlogic.storage.cash.StoreManager;

class BillCollectionHandler
extends UtilityHandler
implements Handler {
    private final Handler next;
    private final Logger log;

    public BillCollectionHandler(Handler next, Logger log) {
        this.next = next;
        this.log = log;
    }

    @Override
    public void process(BoxId request) {
        this.log.info((Object)"Process bill collection");
        if (this.hasFlag(1)) {
            if (this.hasFlag(2)) {
                this.log.info((Object)"Ask a question");
                this.setInSessionCollectionInfo();
                Dialog.show((String)"action/stackout/collect_cashin", actionId -> {
                    if (this.isMakeAction(actionId)) {
                        this.makeCollection(request, request, null);
                    } else {
                        this.log.info((Object)"User skip this action");
                        BillCollectionHandler.sendEvent(EventType.VoidMoneyCollection, request);
                        this.next(request);
                    }
                });
            } else {
                this.makeCollection(request, request, null);
            }
        } else {
            this.log.info((Object)"Disabled, skip this step");
            this.next(request);
        }
    }

    @Override
    protected void next(BoxId request) {
        this.next.process(request);
    }

    private void setInSessionCollectionInfo() {
        try {
            CashAcceptorDevice bv = FxEnv.getBillValidator();
            Session.setItem("bill_acceptor_state", this.getDeviceState((Device)bv));
            PrintSpooler ps = FxEnv.getPrintSpooler();
            Session.setItem("printer_state", this.getDeviceState((Device)ps));
            Box box = StoreManager.getBox((BoxId)CollectionRequest.DEFAULT_BILL_BOX);
            if (box != null) {
                SimpleDateFormat sdf = new SimpleDateFormat("dd MMMM yyyy");
                Session.setItem("last_collection_date", box.getLastEmpty() != null ? sdf.format(box.getLastEmpty()) : "-");
                Map<String, Integer> sumMap = FinUtils.getTotalBoxSum(box);
                if (sumMap.isEmpty()) {
                    sumMap.put(SystemProp.getDefaultCurrency(), 0);
                }
                String strTotalSum = String.join((CharSequence)",", sumMap.entrySet().stream().map(e -> SumFormatter.format(new Sum(((Integer)e.getValue()).intValue(), (String)e.getKey()))).collect(Collectors.toList()));
                Session.setItem("bill_collection_sum", strTotalSum);
            }
        }
        catch (Exception ex) {
            this.log.warn((Object)ex, (Throwable)ex);
        }
    }

    private String getDeviceState(Device dev) {
        if (dev != null) {
            DeviceState bvState = dev.getLastState();
            String state = HdwMsg.getState((int)bvState.getDeviceClass(), (int)bvState.getState());
            StringBuilder sb = new StringBuilder(state);
            if (dev.getLastInfo() != null) {
                sb.append(" ").append(dev.getLastInfo().getVendor()).append(" ").append(dev.getLastInfo().getModel());
            }
            return sb.toString();
        }
        return null;
    }
}

