/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.hdw.bvr;

import fxterm.app.id.LoggerId;
import fxterm.core.Sequence;
import fxterm.core.hdw.bvr.StoreData;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.srv.cash.Statistics;
import ru.softlogic.storage.io.ObjectIO;
import ru.softlogic.storage.io.Serializator;
import ru.softlogic.storage.io.SimpleSerializator;

public class StatisticStore {
    private ObjectIO<StoreData> io;
    private StoreData sd;
    private short deviceClass;
    private final Logger log = LoggerId.APP;

    public StatisticStore(File file, short deviceClass) {
        if (file == null) {
            throw new NullPointerException("File is null");
        }
        this.io = new ObjectIO((Serializator)new SimpleSerializator(file));
        this.deviceClass = deviceClass;
    }

    public synchronized void addEvent(int event) {
        this.check();
        Map<Integer, Integer> stat = this.sd.getStat();
        stat.put(event, stat.getOrDefault(event, 0) + 1);
        this.io.write((Serializable)this.sd);
    }

    public synchronized Statistics resetStatistics() {
        this.check();
        this.log.info((Object)"StatisticStore: Reset statistics");
        StoreData newSd = new StoreData();
        Statistics st = new Statistics(Sequence.getStatisticsId(), this.sd.getFrom(), newSd.getFrom(), this.deviceClass);
        Map<Integer, Integer> stat = this.sd.getStat();
        st.setTotal(stat.getOrDefault(1, 0) - stat.getOrDefault(8, 0));
        st.setOpticReject(stat.getOrDefault(3, 0).intValue());
        st.setTransportReject(stat.getOrDefault(6, 0).intValue());
        st.setCommonReject(stat.getOrDefault(2, 0).intValue());
        this.sd = newSd;
        this.io.write((Serializable)this.sd);
        return st;
    }

    public synchronized Date getFrom() {
        this.check();
        return this.sd.getFrom();
    }

    private void check() {
        if (this.sd == null) {
            this.sd = (StoreData)this.io.read((Serializable)new StoreData());
        }
    }
}

