/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.hdw.bvr;

import fxterm.app.id.LoggerId;
import org.apache.log4j.Logger;
import plfx.GuiNotifier;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hdw.dev.cashacc.StackListener;
import ru.softlogic.storage.cash.Box;
import ru.softlogic.storage.cash.InternalStorage;
import ru.softlogic.storage.cash.Store;
import ru.softlogic.storage.cash.StoreManager;

class NewCashCounterListener
implements StackListener {
    private final InternalStorage cash;
    private final InternalStorage coin;
    private final Logger log;

    public NewCashCounterListener(InternalStorage cash, InternalStorage coin) {
        this.cash = cash;
        this.coin = coin;
        this.log = LoggerId.CASHIN;
    }

    public synchronized void onStack(Denomination denomination, int boxId) {
        if (denomination.getType() == 0) {
            if (boxId == 1) {
                this.log.info((Object)"Move to payout box, ignore");
            } else {
                this.addToStorage((short)3, this.cash, 0, denomination);
            }
        } else {
            this.addToStorage((short)4, this.coin, 0, denomination);
        }
    }

    private void addToStorage(short type, InternalStorage storage, int boxId, Denomination denomination) {
        Store st = StoreManager.getDefaultStore((short)type);
        if (st != null) {
            Box b = st.getBoxes()[boxId];
            if (b != null) {
                storage.add(b, denomination, 1);
            } else {
                GuiNotifier.notifyErrorOnce((String)("Box id=" + boxId + " is not found in cashstore"));
            }
        } else {
            GuiNotifier.notifyErrorOnce((String)("Store for type=" + type + " is not found"));
        }
    }
}

