/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.hdw.bvr;

import fxterm.app.id.LoggerId;
import javafx.event.EventHandler;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.dev.cashacc.DriverControl;

class GuiControl
implements EventHandler<KeyEvent> {
    private DriverControl control;
    private final Logger log = LoggerId.CASHIN;

    public GuiControl(DriverControl control) {
        if (control == null) {
            throw new NullPointerException("DriverControl is not set");
        }
        this.control = control;
    }

    public void handle(KeyEvent t) {
        this.log.info((Object)("Press: " + t.getCode()));
        if (t.getCode() == KeyCode.F1) {
            this.processKey(t, 0);
        } else if (t.getCode() == KeyCode.F2) {
            this.processKey(t, 1);
        } else if (t.getCode() == KeyCode.F3) {
            this.processKey(t, 2);
        } else if (t.getCode() == KeyCode.F4) {
            this.processKey(t, 3);
        } else if (t.getCode() == KeyCode.F5) {
            this.processKey(t, 4);
        } else if (t.getCode() == KeyCode.F6) {
            this.processKey(t, 5);
        } else if (t.getCode() == KeyCode.F7) {
            this.processKey(t, 6);
        } else if (t.getCode() == KeyCode.F8) {
            this.processKey(t, 7);
        } else if (t.getCode() == KeyCode.F9) {
            this.log.info((Object)"Notify stack out");
            this.control.onStackOut();
        } else if (t.getCode() == KeyCode.F10) {
            this.log.info((Object)"Notify jamm");
            this.control.onJamm();
        } else if (t.getCode() == KeyCode.F12) {
            this.log.info((Object)"Notify recover");
            this.control.onRecover();
        }
    }

    private void processKey(KeyEvent t, int noteId) {
        this.log.info((Object)("Notify note " + noteId));
        if (t.isAltDown()) {
            this.log.info((Object)"Alt is pressed, skip");
        } else if (t.isControlDown()) {
            this.control.onFroudNote(noteId);
        } else if (t.isShiftDown()) {
            this.control.onNote(noteId);
        } else {
            this.control.onProtectedNote(noteId);
        }
    }
}

