/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.hdw.bvr;

import fxterm.app.id.LoggerId;
import fxterm.core.hdw.bvr.col.CollectionQueue;
import fxterm.module.Module;
import fxterm.module.ModuleStore;
import fxterm.msg.Messages;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.handling.DeviceState;
import ru.softlogic.hdw.handling.DeviceStateListener;
import ru.softlogic.storage.cash.BoxId;

class CollectionListener
implements DeviceStateListener {
    private final DeviceId deviceId;
    private final Logger log = LoggerId.APP;

    public CollectionListener(DeviceId deviceId) {
        if (deviceId == null) {
            throw new NullPointerException("DeviceId is null");
        }
        this.deviceId = deviceId;
    }

    public void onState(DeviceState state) {
        if (state.getState() == 2) {
            Module m = ModuleStore.getModule();
            if (m != null && (m.getType() == 1 || m.getType() == 0)) {
                CollectionQueue.addCollection(new BoxId(this.deviceId.getDeviceClass(), this.deviceId.getNumber(), 0));
            } else {
                this.log.error((Object)("Can't process collection, current module: " + Messages.getModuleType(m)));
            }
        }
    }
}

