/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.hdw.bvr;

import fxterm.app.FxEnv;
import fxterm.app.id.LoggerId;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.currency.DefaultComparator;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hdw.dev.cashacc.CashAcceptorDevice;
import ru.softlogic.hdw.dev.cashacc.CashInOperation;

public class CashManager {
    private final CashAcceptorDevice billAcceptor;
    private final CashAcceptorDevice coinAcceptor;
    private final Logger log = LoggerId.PAY;

    public CashManager(CashAcceptorDevice billAcceptor, CashAcceptorDevice coinAcceptor) {
        this.billAcceptor = billAcceptor;
        this.coinAcceptor = coinAcceptor;
    }

    public boolean isOperable() {
        boolean billAccOperable = this.billAcceptor != null && this.billAcceptor.isOperable();
        boolean coinAccOperable = this.coinAcceptor != null && this.coinAcceptor.isOperable();
        return billAccOperable || coinAccOperable;
    }

    public void enable(CashInOperation operation) {
        if (operation == null) {
            throw new NullPointerException("CashInOperation is null");
        }
        if (this.billAcceptor != null) {
            if (this.billAcceptor.getCurrencies().contains(operation.getCurrency())) {
                this.billAcceptor.enable(operation);
            } else {
                this.log.info((Object)("Bill acceptor is not support currency: " + operation.getCurrency() + ", skip"));
            }
        }
        if (this.coinAcceptor != null) {
            if (this.coinAcceptor.getCurrencies().contains(operation.getCurrency())) {
                this.coinAcceptor.enable(operation);
            } else {
                this.log.info((Object)("Coin acceptor is not support currency: " + operation.getCurrency() + ", skip"));
            }
        }
    }

    public void disable(boolean waitSafe) {
        boolean billWait = false;
        if (this.billAcceptor != null && this.billAcceptor.isEnabled()) {
            this.log.info((Object)"Disable bill acceptor");
            this.billAcceptor.disable();
            this.log.info((Object)"Done");
            billWait = true;
        }
        boolean coinWait = false;
        if (this.coinAcceptor != null && this.coinAcceptor.isEnabled()) {
            this.log.info((Object)"Disable coin acceptor");
            this.coinAcceptor.disable();
            this.log.info((Object)"Done");
            coinWait = true;
        }
        if (waitSafe) {
            try {
                if (billWait) {
                    this.log.info((Object)"Wait bill acceptor safe state");
                    this.billAcceptor.waitSafeState();
                    this.log.info((Object)"Done");
                }
                if (coinWait) {
                    this.log.info((Object)"Wait coin acceptor safe state");
                    this.coinAcceptor.waitSafeState();
                    this.log.info((Object)"Done");
                }
            }
            catch (InterruptedException ex) {
                this.log.error((Object)"Thread interrupted");
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean currencySupport(String currency) {
        CashManager cashManager = FxEnv.getCashManager();
        Set<Denomination> hdwDenomination = cashManager.getHdwDenomination(currency);
        return hdwDenomination != null && !hdwDenomination.isEmpty();
    }

    public Set<Denomination> getHdwDenomination(String currency) {
        SortedSet bills;
        SortedSet coins = this.coinAcceptor != null ? this.coinAcceptor.getDenominations(currency) : null;
        SortedSet sortedSet = bills = this.billAcceptor != null ? this.billAcceptor.getDenominations(currency) : null;
        if (coins == null) {
            return bills;
        }
        TreeSet<Denomination> res = new TreeSet<Denomination>((Comparator<Denomination>)new DefaultComparator());
        res.addAll(coins);
        for (Denomination d : bills) {
            if (d.getType() != 0) continue;
            res.add(d);
        }
        return res;
    }

    public Set<Denomination> getHdwDenomination() {
        SortedSet bills;
        SortedSet coins = this.coinAcceptor != null ? this.coinAcceptor.getDenominations() : null;
        SortedSet sortedSet = bills = this.billAcceptor != null ? this.billAcceptor.getDenominations() : null;
        if (coins == null) {
            return bills;
        }
        TreeSet<Denomination> res = new TreeSet<Denomination>((Comparator<Denomination>)new DefaultComparator());
        res.addAll(coins);
        for (Denomination d : bills) {
            if (d.getType() != 0) continue;
            res.add(d);
        }
        return res;
    }

    public Set<String> getAvailableCurrency() {
        SortedSet coins = this.coinAcceptor != null ? this.coinAcceptor.getDenominations() : null;
        SortedSet bills = this.billAcceptor != null ? this.billAcceptor.getDenominations() : null;
        TreeSet<String> set = new TreeSet<String>();
        if (coins != null) {
            for (Denomination coin : coins) {
                set.add(coin.getCurrency());
            }
        }
        if (bills != null) {
            for (Denomination bill : bills) {
                set.add(bill.getCurrency());
            }
        }
        return set;
    }
}

