/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.hdw.bvr;

import fxterm.app.id.LoggerId;
import fxterm.core.hdw.bvr.BvrStatSender;
import fxterm.core.hdw.bvr.StatisticStore;
import java.util.Date;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import ru.softlogic.srv.connector.ClientInterface;

class BvrStateLoader
implements Runnable {
    private static final long INTERVAL = 86400000L;
    private final StatisticStore store;
    private final ClientInterface clientInterface;
    private final ScheduledExecutorService service;
    private final Logger log = LoggerId.APP;

    public BvrStateLoader(StatisticStore store, ClientInterface clientInterface, ScheduledExecutorService service) {
        if (store == null) {
            throw new NullPointerException("StatisticStore is null");
        }
        if (clientInterface == null) {
            throw new NullPointerException("ClientInterface is null");
        }
        if (service == null) {
            throw new NullPointerException("ScheduledExecutorService is null");
        }
        this.store = store;
        this.clientInterface = clientInterface;
        this.service = service;
    }

    @Override
    public void run() {
        this.log.info((Object)"Start to load bvr statistic sender");
        Date d = this.store.getFrom();
        this.log.info((Object)("Last send: " + d));
        long current = new Date().getTime() - d.getTime();
        this.log.info((Object)("Time passed, sec: " + current / 1000L));
        BvrStatSender bss = new BvrStatSender(this.store, this.clientInterface);
        long next = 10000L;
        if (current > 0L && current < 86400000L) {
            next = 86400000L - current;
        }
        this.log.info((Object)("Next launch, sec: " + next / 1000L));
        this.service.scheduleAtFixedRate(bss, next, 86400000L, TimeUnit.MILLISECONDS);
    }
}

