/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.hdw.bvr;

import fxterm.app.id.LoggerId;
import fxterm.core.timer.Timer;
import java.util.Objects;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.dev.cashacc.BvrState;
import ru.softlogic.hdw.dev.cashacc.EventListener;
import ru.softlogic.hdw.handling.DeviceState;
import ru.softlogic.hdw.handling.DeviceStateListener;
import ru.softlogic.srv.api.status.DeviceStatus;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.system.util.ThreadUtil;

class BvrStateListener
implements Runnable,
DeviceStateListener,
EventListener {
    private static final int ERROR_TIMEOUT = 180;
    private static final int MAX_ERRORS = 10;
    private static final int MAX_TRIES = 3;
    private final ClientInterface server;
    private DeviceState localStatus;
    private DeviceState serverStatus;
    private long lastChange;
    private int errCount;
    private int failTries;
    private final Logger log = LoggerId.CASHIN_OBSERVER;
    private boolean warning;

    public BvrStateListener(ClientInterface server) {
        this.server = Objects.requireNonNull(server, "ClientInterface is null");
        this.localStatus = new DeviceState(3, 0);
        this.lastChange = Timer.currentSec();
    }

    @Override
    public void run() {
        this.log.debug((Object)"Start thread");
        while (!Thread.currentThread().isInterrupted()) {
            long now = Timer.currentSec();
            if (!this.localStatus.equals((Object)this.serverStatus) && (this.localStatus.isOk() || this.warning || now - this.lastChange >= 180L)) {
                this.log.debug((Object)("State change, current: " + this.localStatus + ", remote: " + this.serverStatus));
                this.log.debug((Object)"Send state to server");
                int warningState = this.warning ? 1 : 0;
                int localState = this.localStatus.getState();
                this.serverStatus = new BvrState(localState, warningState);
                this.server.sendStatus(new DeviceStatus(Short.valueOf((short)3), localState, warningState));
                this.lastChange = now;
            }
            ThreadUtil.sleep((long)10000L);
        }
        this.log.debug((Object)"Stop thread");
    }

    public void onState(DeviceState state) {
        if (!this.localStatus.equals((Object)state)) {
            this.log.debug((Object)("Get new state: " + state));
            this.localStatus = state;
            this.lastChange = Timer.currentSec();
        }
    }

    public void onStack() {
        this.errCount = 0;
        this.failTries = 0;
        if (this.warning) {
            this.log.info((Object)"Clear warning flag");
            this.warning = false;
            this.lastChange = Timer.currentSec();
        }
    }

    public void onEvent(int event) {
        switch (event) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                ++this.errCount;
                break;
            }
            case 1: {
                ++this.failTries;
                break;
            }
            case 7: {
                this.onStack();
            }
        }
        if (this.errCount >= 10 && this.failTries >= 3 && !this.warning) {
            this.log.info((Object)"Too many rejects. Set warning flag");
            this.warning = true;
            this.lastChange = Timer.currentSec();
        }
    }
}

