/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.hdw.bvr;

import fxterm.app.ApplicationException;
import fxterm.app.BaseDriverFactory;
import fxterm.app.FxEnvInit;
import fxterm.app.PaylogicResources;
import fxterm.app.id.LoggerId;
import fxterm.core.cash.CompatCashFactory;
import fxterm.core.hdw.AppTransferListener;
import fxterm.core.hdw.CommonDeviceInfoListener;
import fxterm.core.hdw.SrvDeviceStateListener;
import fxterm.core.hdw.SrvProblemListener;
import fxterm.core.hdw.bvr.BvrEventListener;
import fxterm.core.hdw.bvr.BvrStateListener;
import fxterm.core.hdw.bvr.BvrStateLoader;
import fxterm.core.hdw.bvr.CashManager;
import fxterm.core.hdw.bvr.CollectionListener;
import fxterm.core.hdw.bvr.GuiControl;
import fxterm.core.hdw.bvr.NewCashCounterListener;
import fxterm.core.hdw.bvr.StatisticStore;
import fxterm.session.Session;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.event.EventHandler;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.CreatingException;
import ru.softlogic.hdw.base.Device;
import ru.softlogic.hdw.dev.cashacc.BvrConfiguration;
import ru.softlogic.hdw.dev.cashacc.BvrOptions;
import ru.softlogic.hdw.dev.cashacc.CashAcceptor;
import ru.softlogic.hdw.dev.cashacc.CashAcceptorDevice;
import ru.softlogic.hdw.dev.cashacc.CashAcceptorDriver;
import ru.softlogic.hdw.dev.cashacc.CashAcceptorFactory;
import ru.softlogic.hdw.dev.cashacc.CvrConfiguration;
import ru.softlogic.hdw.dev.cashacc.DriverControl;
import ru.softlogic.hdw.dev.cashacc.EventListener;
import ru.softlogic.hdw.dev.cashacc.StackListener;
import ru.softlogic.hdw.handling.DeviceInfoListener;
import ru.softlogic.hdw.handling.DeviceProblemListener;
import ru.softlogic.hdw.handling.DeviceStateListener;
import ru.softlogic.io.Port;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.storage.cash.BaseBox;
import ru.softlogic.storage.cash.BaseStore;
import ru.softlogic.storage.cash.Box;
import ru.softlogic.storage.cash.BoxInfo;
import ru.softlogic.storage.cash.InternalStorage;
import ru.softlogic.storage.cash.Store;
import ru.softlogic.storage.cash.StoreListener;
import ru.softlogic.storage.cash.StoreManager;
import ru.softlogic.storage.io.DurableSerializator;
import ru.softlogic.storage.io.FileSet;
import ru.softlogic.storage.io.PathLockException;
import ru.softlogic.storage.io.Serializator;
import ru.softlogic.storage.io.WrongPathException;
import ru.softlogic.system.util.PathUtils;

public class BvrDriverFactory
extends BaseDriverFactory {
    private BvrDriverFactory() {
    }

    public static CashManager createCashinSystem(BvrConfiguration bvrConf, CvrConfiguration cvrConf, Stage stage, ClientInterface clientInterface, PaylogicResources resources, ScheduledExecutorService scheduler) throws ApplicationException {
        NewCashCounterListener sl = BvrDriverFactory.createStorages(resources);
        CashAcceptorDevice bill = BvrDriverFactory.createBillValidator(bvrConf, stage, sl, clientInterface, resources, scheduler);
        CashAcceptorDevice coin = BvrDriverFactory.createCoinValidator(cvrConf, sl, clientInterface, resources);
        return new CashManager(bill, coin);
    }

    private static CashAcceptorDevice createBillValidator(BvrConfiguration bvrConf, Stage stage, StackListener stackListener, ClientInterface clientInterface, PaylogicResources resources, ScheduledExecutorService scheduler) throws ApplicationException {
        log.info((Object)"-------------------------------------------------------------------------------");
        if (bvrConf != null) {
            log.info((Object)("Try to create bill validator type=" + bvrConf.getType() + ", port=" + bvrConf.getPort()));
            try {
                CashAcceptorDriver cad = CashAcceptorFactory.createBillDriver((String)bvrConf.getType(), (SerialPort)bvrConf.getPort(), (BvrOptions)bvrConf.getOptions(), (String)CompatCashFactory.getSystemCurrency(), (Logger)LoggerId.CASHIN);
                log.info((Object)("Driver create successfully and contains " + cad.getThreads().size() + " thread(s)"));
                DriverControl control = cad.getDriverControl();
                if (control != null) {
                    log.info((Object)"Add gui control");
                    stage.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new GuiControl(control));
                }
                CashAcceptorDevice ca = cad.getCashAcceptor();
                Session.setDefaultItem("multycash", ca.isEquipped(CashAcceptor.Module.BulkAcc));
                Store cashStore = StoreManager.getDefaultStore((short)ca.getDeviceId().getDeviceClass());
                cashStore.addListener((StoreListener)new AppTransferListener(ca.getDeviceId(), clientInterface));
                ca.addDeviceProblemListener((DeviceProblemListener)new SrvProblemListener(clientInterface));
                ca.addDeviceInfoListener((DeviceInfoListener)new CommonDeviceInfoListener(clientInterface));
                ca.addStackListener(stackListener);
                ca.addStateListener((DeviceStateListener)new CollectionListener(ca.getDeviceId()));
                FxEnvInit.setBillValidator(ca);
                resources.getThreads().addAll(cad.getThreads());
                BvrStateListener caso = new BvrStateListener(clientInterface);
                ca.addStateListener((DeviceStateListener)caso);
                ca.addEventListener((EventListener)caso);
                resources.getThreads().add(new Thread((Runnable)caso, "drv(" + bvrConf.getType() + "@state)"));
                StatisticStore store = new StatisticStore(PathUtils.getFilePath((String)"/data/cash-in//cash-acceptor-stat.obj"), 3);
                ca.addEventListener((EventListener)new BvrEventListener(store));
                scheduler.schedule(BvrDriverFactory._p(new BvrStateLoader(store, clientInterface, scheduler)), 5L, TimeUnit.SECONDS);
                BvrDriverFactory.setSensorListener((Device)ca, clientInterface);
                return ca;
            }
            catch (CreatingException ex) {
                BvrDriverFactory.onCreatingError(clientInterface, (short)3, bvrConf.getType(), (Port)bvrConf.getPort(), (Exception)((Object)ex));
                throw new ApplicationException(6, "Bill validator is not found", ex);
            }
        }
        throw new ApplicationException(6, "Bill validator is not found");
    }

    private static CashAcceptorDevice createCoinValidator(CvrConfiguration cvrConf, StackListener stackListener, ClientInterface clientInterface, PaylogicResources resources) {
        log.info((Object)"-------------------------------------------------------------------------------");
        if (cvrConf != null) {
            if (cvrConf.isEnable()) {
                log.info((Object)("Try to create coin validator type=" + cvrConf.getType() + ", port=" + cvrConf.getPort()));
                try {
                    Logger l = BvrDriverFactory.createLogger("coin", "coin");
                    CashAcceptorDriver cad = CashAcceptorFactory.createCoinDriver((String)cvrConf.getType(), (SerialPort)cvrConf.getPort(), (String)CompatCashFactory.getSystemCurrency(), (Logger)l);
                    log.info((Object)("Driver create successfully and contains " + cad.getThreads().size() + " thread(s)"));
                    CashAcceptorDevice ca = cad.getCashAcceptor();
                    Store cashStore = StoreManager.getDefaultStore((short)ca.getDeviceId().getDeviceClass());
                    cashStore.addListener((StoreListener)new AppTransferListener(ca.getDeviceId(), clientInterface));
                    ca.addDeviceProblemListener((DeviceProblemListener)new SrvProblemListener(clientInterface));
                    ca.addDeviceInfoListener((DeviceInfoListener)new CommonDeviceInfoListener(clientInterface));
                    ca.addStateListener((DeviceStateListener)new SrvDeviceStateListener(clientInterface));
                    ca.addStackListener(stackListener);
                    FxEnvInit.setCoinValidator(ca);
                    resources.getThreads().addAll(cad.getThreads());
                    BvrDriverFactory.setSensorListener((Device)ca, clientInterface);
                    return ca;
                }
                catch (CreatingException ex) {
                    BvrDriverFactory.onCreatingError(clientInterface, (short)4, cvrConf.getType(), (Port)cvrConf.getPort(), (Exception)((Object)ex));
                }
            } else {
                log.info((Object)"Coin validator is not active");
            }
        } else {
            log.info((Object)"Coin acceptor section or options is not found");
        }
        return null;
    }

    private static NewCashCounterListener createStorages(PaylogicResources resources) throws ApplicationException {
        try {
            InternalStorage cash = BvrDriverFactory.createStore((short)3, "bvr", resources.getSerializators());
            InternalStorage coin = BvrDriverFactory.createStore((short)4, "cvr", resources.getSerializators());
            return new NewCashCounterListener(cash, coin);
        }
        catch (PathLockException | WrongPathException ex) {
            throw new ApplicationException(6, "Error on create cashbox stores", ex);
        }
    }

    private static InternalStorage createStore(short deviceClass, String typeStr, List<Serializator> serializators) throws PathLockException, WrongPathException {
        InternalStorage storage = BvrDriverFactory.createStorage(typeStr, serializators);
        int features = 0xD | (deviceClass == 4 ? 64 : 0);
        Box[] boxes = new Box[]{new BaseBox(0, new BoxInfo(0, Integer.valueOf(1000), features), storage)};
        BaseStore store = new BaseStore("", boxes, storage);
        StoreManager.registerStore((short)deviceClass, (Store)store);
        return storage;
    }

    private static InternalStorage createStorage(String type, List<Serializator> serializators) throws WrongPathException, PathLockException {
        DurableSerializator s = new DurableSerializator(new FileSet(PathUtils.getPath((String)"/data/cash-in/"), type + ".0{0}"));
        serializators.add((Serializator)s);
        return new InternalStorage((Serializator)s, type);
    }
}

