/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.hdw.bar;

import javafx.event.EventHandler;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import ru.softlogic.hdw.dev.barcode.Control;

public class BarcodeNotifier
implements EventHandler<KeyEvent> {
    private Control control;
    private static final String shiftFrom = "`1234567890-=[]\\;',./";
    private static final String shiftTo = "~!@#$%^&*()_+{}|:\"<>?";

    public BarcodeNotifier(Control control) {
        if (control == null) {
            throw new NullPointerException("Control is not set");
        }
        this.control = control;
    }

    public void handle(KeyEvent t) {
        String text = t.getText();
        if ((text == null || text.isEmpty()) && KeyCode.DOWN.equals((Object)t.getCode())) {
            text = "\n";
        }
        if (KeyCode.DIGIT2.equals((Object)t.getCode()) && t.isControlDown()) {
            text = "\n";
        }
        if (text != null && !text.isEmpty()) {
            char ch = text.charAt(0);
            if (t.isShiftDown()) {
                if (ch >= 'a' && ch <= 'z') {
                    ch = Character.toUpperCase(ch);
                } else {
                    int index = shiftFrom.indexOf(ch);
                    if (index >= 0) {
                        ch = shiftTo.charAt(index);
                    }
                }
            }
            this.control.onSymbol(ch);
        }
    }
}

