/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.hdw.bar;

import fxterm.app.BaseDriverFactory;
import fxterm.app.PaylogicResources;
import fxterm.core.hdw.CommonDeviceInfoListener;
import fxterm.core.hdw.SrvDeviceStateListener;
import fxterm.core.hdw.SrvProblemListener;
import fxterm.core.hdw.bar.BarcodeNotifier;
import fxterm.core.hdw.bar.GuiBarcodeListener;
import fxterm.core.hdw.bar.ModuleBarcodeListener;
import javafx.event.EventHandler;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.CreatingException;
import ru.softlogic.hdw.base.Device;
import ru.softlogic.hdw.dev.barcode.BarConfiguration;
import ru.softlogic.hdw.dev.barcode.BarcodeFactory;
import ru.softlogic.hdw.dev.barcode.BarcodeListener;
import ru.softlogic.hdw.dev.barcode.BarcodeScanner;
import ru.softlogic.hdw.dev.barcode.BarcodeScannerDriver;
import ru.softlogic.hdw.dev.barcode.Control;
import ru.softlogic.hdw.handling.DeviceInfoListener;
import ru.softlogic.hdw.handling.DeviceProblemListener;
import ru.softlogic.hdw.handling.DeviceStateListener;
import ru.softlogic.io.Port;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.srv.connector.ClientInterface;

public class BarDriverFactory
extends BaseDriverFactory {
    public static void createBarcode(BarConfiguration barConf, Stage stage, ClientInterface clientInterface, PaylogicResources resources) {
        log.info((Object)"-------------------------------------------------------------------------------");
        if (barConf != null) {
            if (barConf.isEnable()) {
                log.info((Object)("Try to create barcode driver, type=" + barConf.getType() + ", port=" + barConf.getPort()));
                try {
                    Logger l = BarDriverFactory.createLogger("barcode", "add/dev-barcode");
                    BarcodeScannerDriver bsd = BarcodeFactory.createDriver((String)barConf.getType(), (SerialPort)barConf.getPort(), (Logger)l);
                    log.info((Object)("Driver create successfully and contains " + bsd.getThreads().size() + " thread(s)"));
                    Control ctrl = bsd.getControl();
                    if (ctrl != null) {
                        log.info((Object)"Add gui barcode notifier");
                        stage.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new BarcodeNotifier(ctrl));
                    }
                    BarcodeScanner bs = bsd.getBarcodeScanner();
                    bs.addDeviceProblemListener((DeviceProblemListener)new SrvProblemListener(clientInterface));
                    bs.addDeviceInfoListener((DeviceInfoListener)new CommonDeviceInfoListener(clientInterface));
                    bs.addStateListener((DeviceStateListener)new SrvDeviceStateListener(clientInterface));
                    bs.addBarcodeListener((BarcodeListener)new GuiBarcodeListener(new ModuleBarcodeListener()));
                    resources.getThreads().addAll(bsd.getThreads());
                    BarDriverFactory.setSensorListener((Device)bs, clientInterface);
                }
                catch (CreatingException ex) {
                    BarDriverFactory.onCreatingError(clientInterface, (short)10, barConf.getType(), (Port)barConf.getPort(), (Exception)((Object)ex));
                }
            } else {
                log.info((Object)"Barcode scanner is not active");
            }
        } else {
            log.info((Object)"Barcode section or options is not found");
        }
    }
}

