/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.hdw;

import fxterm.app.FxEnv;
import java.util.Objects;
import org.apache.commons.codec.binary.Base64;
import ru.softlogic.hdw.DeviceClass;
import ru.softlogic.hdw.dev.ioc.IOController;
import ru.softlogic.hdw.dev.sensors.SensorEvent;
import ru.softlogic.hdw.dev.sensors.SensorsListener;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.hdw.handling.HdwMsg;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.srv.connector.ClientInterface;

public class PMSensorListener
implements SensorsListener {
    private final ClientInterface client;

    public PMSensorListener(ClientInterface client) {
        this.client = Objects.requireNonNull(client, "ClientInterface is null");
    }

    public void onChange(SensorEvent se) {
        String device = DeviceClass.asStr((short)se.getDeviceClass());
        String sensor = HdwMsg.getSensor((int)se.getType());
        String event = HdwMsg.getSensorEvent((int)se.getType(), (int)se.getValue());
        String msg = device + ". " + sensor + "(" + se.getId() + "): " + event + "; " + PMSensorListener.getSerialBase64();
        EventType et = EventType.Sensor;
        if (se.getDeviceClass() == 21 && se.getType() == 1) {
            if (se.getValue() == 1) {
                et = EventType.PostStationDoorOpened;
            } else if (se.getValue() == 0) {
                et = EventType.PostStationDoorClosed;
            }
        }
        this.client.sendEvent(new Event[]{new Event(et, msg)});
    }

    private static String getSerial() {
        DeviceInfo di;
        String res = null;
        IOController ioc = FxEnv.getIOController();
        if (ioc != null && (di = ioc.getLastInfo()) != null) {
            res = di.getSerial();
        }
        return res;
    }

    private static String getSerialBase64() {
        String serial = PMSensorListener.getSerial();
        if (serial == null) {
            return null;
        }
        return new String(Base64.encodeBase64((byte[])serial.getBytes()));
    }
}

