/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.hdw;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import ru.softlogic.hdw.handling.CashInfo;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.hdw.handling.DeviceInfoListener;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.srv.connector.ws.stub.CashBoxInfoStub;
import ru.softlogic.srv.connector.ws.stub.DeviceInfoStub;
import ru.softlogic.storage.cash.BoxInfo;

public abstract class CompatDeviceInfoListener
implements DeviceInfoListener {
    protected final ClientInterface client;

    public CompatDeviceInfoListener(ClientInterface client) {
        if (client == null) {
            throw new NullPointerException("ClientInterface is null");
        }
        this.client = client;
    }

    public final void onDeviceInfo(DeviceInfo info) {
        DeviceInfoStub di = new DeviceInfoStub(Short.valueOf(info.getDeviceClass()), info.getDeviceType());
        di.setFirmware(info.getFirmware());
        di.setFirmware1(info.getFirmware1());
        di.setFirmware2(info.getFirmware2());
        di.setPort(info.getPort());
        di.setInfo(info.getInfo());
        di.setModel(info.getModel());
        di.setProto(info.getProto());
        di.setVendor(info.getVendor());
        di.setDriver(info.getDriver());
        di.setSerial(info.getSerial());
        di.setHasUpdate(info.isHasUpdate());
        if (info.getUpdateList() != null) {
            di.setUpdateInfo(info.getUpdateList().toString());
        }
        if (info.getCashInfo() != null) {
            CashInfo ci = info.getCashInfo();
            di.setCurrencies(ci.getCurrencies());
            if (ci.getDenominations() != null) {
                di.setCashUnits(ci.getDenominations().stream().map(denomination -> denomination.getId()).collect(Collectors.toSet()));
            }
            if (ci.getCashBoxInfos() != null && !ci.getCashBoxInfos().isEmpty()) {
                HashMap map = new HashMap();
                for (Map.Entry entry : ci.getCashBoxInfos().entrySet()) {
                    BoxInfo cbi = (BoxInfo)entry.getValue();
                    CashBoxInfoStub stub = new CashBoxInfoStub();
                    stub.setCapacity(cbi.getCapacity());
                    stub.setFeatures(cbi.getFeatures());
                    stub.setType(cbi.getType());
                    stub.setDispensingAccuracy(cbi.getDispensingAccuracy());
                    stub.setMinimumFilling(cbi.getMinimumFilling());
                    map.put(entry.getKey(), stub);
                }
                di.setCashBoxInfos(map);
            }
        }
        this.client.send(di);
        this.afterSend(info);
    }

    protected abstract void afterSend(DeviceInfo var1);
}

