/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.hdw;

import fxterm.app.BaseDriverFactory;
import fxterm.app.FxEnv;
import fxterm.app.FxEnvInit;
import fxterm.app.PaylogicResources;
import fxterm.core.hdw.CommonDeviceInfoListener;
import fxterm.core.hdw.PMSensorListener;
import fxterm.core.hdw.SrvDeviceStateListener;
import fxterm.core.hdw.SrvProblemListener;
import fxterm.module.card.CardModuleHandler;
import fxterm.module.card.ReverseTask;
import java.io.File;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import ru.softlogic.cards.v2.module.CardApplication;
import ru.softlogic.hdw.CreatingException;
import ru.softlogic.hdw.base.Device;
import ru.softlogic.hdw.dev.crd.CardReader;
import ru.softlogic.hdw.dev.crd.CardReaderDriver;
import ru.softlogic.hdw.dev.crd.CardReaderFactory;
import ru.softlogic.hdw.dev.crd.CardReaderOptions;
import ru.softlogic.hdw.dev.crd.CrdConfiguration;
import ru.softlogic.hdw.dev.ioc.IOController;
import ru.softlogic.hdw.dev.ioc.IOControllerDriver;
import ru.softlogic.hdw.dev.ioc.IOControllerFactory;
import ru.softlogic.hdw.dev.ioc.IocConfiguration;
import ru.softlogic.hdw.dev.sensors.Sensor;
import ru.softlogic.hdw.dev.sensors.SensorDriver;
import ru.softlogic.hdw.dev.sensors.SensorFactory;
import ru.softlogic.hdw.dev.sensors.SensorOptions;
import ru.softlogic.hdw.dev.sensors.SensorsListener;
import ru.softlogic.hdw.dev.sensors.SnrConfiguration;
import ru.softlogic.hdw.handling.DeviceInfoListener;
import ru.softlogic.hdw.handling.DeviceProblemListener;
import ru.softlogic.hdw.handling.DeviceStateListener;
import ru.softlogic.io.Port;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.srv.connector.ClientInterface;

public class CommonDriverFactory
extends BaseDriverFactory {
    private CommonDriverFactory() {
    }

    public static void createCardReader(CrdConfiguration conf, ClientInterface clientInterface, PaylogicResources resources) {
        log.info((Object)"-------------------------------------------------------------------------------");
        if (conf != null) {
            if (conf.isEnable()) {
                log.info((Object)("Try to create card reader, type=" + conf.getType() + ", port=" + conf.getPort()));
                try {
                    Logger l = CommonDriverFactory.createLogger("cardreader", "add/dev-cardreader");
                    CardReaderDriver drv = CardReaderFactory.createDriver((String)conf.getType(), (SerialPort)conf.getPort(), (CardReaderOptions)conf.getCardReaderOptions(), (Logger)l);
                    log.info((Object)("Driver create successfully and contains " + drv.getThreads().size() + " thread(s)"));
                    CardReader dev = drv.getCardReader();
                    dev.addStateListener((DeviceStateListener)new SrvDeviceStateListener(clientInterface));
                    FxEnvInit.setCardReader(dev);
                    resources.getThreads().addAll(drv.getThreads());
                    CommonDriverFactory.setSensorListener((Device)dev, clientInterface);
                }
                catch (CreatingException ex) {
                    CommonDriverFactory.onCreatingError(clientInterface, (short)15, conf.getType(), (Port)conf.getPort(), (Exception)((Object)ex));
                }
            } else {
                log.info((Object)"Card reader is not active");
            }
        } else {
            log.info((Object)"Card reader section or options is not found, create SmartCardIO stub(IN PROGRESS)");
        }
    }

    public static void createCardModule(File conf, ClientInterface clientInterface, PaylogicResources resources) {
        log.info((Object)"-------------------------------------------------------------------------------");
        if (conf.canRead()) {
            try {
                log.info((Object)("Try to create CardApplication from configuration: " + conf.getAbsolutePath()));
                CardApplication app = new CardApplication(conf.getParentFile().getAbsolutePath(), (e, m) -> log.error((Object)(e + " - " + m)));
                log.info((Object)"CardApplication  create successfully");
                CardReader cardReader = app.getCardReader();
                cardReader.addDeviceInfoListener((DeviceInfoListener)new CommonDeviceInfoListener(clientInterface));
                cardReader.addDeviceProblemListener((DeviceProblemListener)new SrvProblemListener(clientInterface));
                cardReader.addStateListener((DeviceStateListener)new SrvDeviceStateListener(clientInterface));
                if (app.getEpp() != null) {
                    app.getEpp().addDeviceInfoListener((DeviceInfoListener)new CommonDeviceInfoListener(clientInterface));
                    app.getEpp().addDeviceProblemListener((DeviceProblemListener)new SrvProblemListener(clientInterface));
                    app.getEpp().addStateListener((DeviceStateListener)new SrvDeviceStateListener(clientInterface));
                }
                if (app.getManager() == null) {
                    throw new CreatingException("CardManager is null");
                }
                resources.getThreads().addAll(app.getThreads());
                FxEnvInit.setCardModuleHandler(new CardModuleHandler(app.getManager()));
                if (FxEnv.getCardModuleHandler().isInit() && FxEnv.getCardModuleHandler().isNeedReverse()) {
                    resources.getThreads().add(new Thread(new ReverseTask()));
                }
                log.info((Object)"Create log");
                CommonDriverFactory.createLogger("cardmodule", "/card/cardmodule", Level.DEBUG);
                CommonDriverFactory.createLogger("emvcore", "/card/emvcore", Level.INFO);
                CommonDriverFactory.createLogger("server", "/card/server", Level.INFO);
                CommonDriverFactory.createLogger("epp", "/card/pinpad", Level.INFO);
                CommonDriverFactory.createLogger("cardreader", "/card/cardreader", Level.INFO);
                CommonDriverFactory.createLogger("processor", "/card/cardmodule", Level.INFO);
                CommonDriverFactory.createLogger("equip", "/card/cardmodule", Level.INFO);
            }
            catch (ClassNotFoundException | NoClassDefFoundError cnfe) {
                log.error((Object)("Card module is not present " + cnfe.getMessage()));
            }
            catch (Throwable ex) {
                log.error((Object)"Error on creating card module", ex);
                clientInterface.sendEvent(new Event[]{new Event(EventType.Warning, ex.getMessage())});
            }
        } else {
            log.info((Object)"Card module configuration  is not found");
        }
    }

    public static void createIOC(IocConfiguration conf, ClientInterface clientInterface, PaylogicResources resources) {
        log.info((Object)"-------------------------------------------------------------------------------");
        if (conf != null) {
            if (conf.isEnable()) {
                log.info((Object)("Try to create IO controller, type=" + conf.getType() + ", port=" + conf.getPort()));
                try {
                    Logger l = CommonDriverFactory.createLogger("ioc", "add/dev-ioc");
                    IOControllerDriver drv = IOControllerFactory.createDriver((String)conf.getType(), (SerialPort)conf.getPort(), (Logger)l);
                    log.info((Object)("Driver create successfully and contains " + drv.getThreads().size() + " thread(s)"));
                    IOController dev = drv.getIOController();
                    dev.addStateListener((DeviceStateListener)new SrvDeviceStateListener(clientInterface));
                    dev.addStateListener((DeviceStateListener)new SrvDeviceStateListener(clientInterface));
                    FxEnvInit.setIOController(dev);
                    resources.getThreads().addAll(drv.getThreads());
                    CommonDriverFactory.setPMSensorListener((Device)dev, clientInterface);
                }
                catch (CreatingException ex) {
                    CommonDriverFactory.onCreatingError(clientInterface, (short)21, conf.getType(), (Port)conf.getPort(), (Exception)((Object)ex));
                }
            } else {
                log.info((Object)"IO controller is not active");
            }
        } else {
            log.info((Object)"IO controller section or options is not found");
        }
    }

    public static void createSensors(SnrConfiguration conf, ClientInterface clientInterface, PaylogicResources resources) {
        log.info((Object)"-------------------------------------------------------------------------------");
        if (conf != null) {
            if (conf.isEnable()) {
                log.info((Object)("Try to create sensor device, type=" + conf.getDriver() + ", port=" + conf.getPort()));
                try {
                    Logger l = CommonDriverFactory.createLogger("sensors", "add/dev-sensors");
                    SensorDriver snrDriver = SensorFactory.createDriver((String)conf.getDriver(), (Port)conf.getPort(), (SensorOptions)conf.getOptions(), (Logger)l);
                    log.info((Object)("Driver create successfully and contains " + snrDriver.getThreads().size() + " thread(s)"));
                    snrDriver.addStateListener((DeviceStateListener)new SrvDeviceStateListener(clientInterface));
                    CommonDriverFactory.setSensorListener((Device)snrDriver, clientInterface);
                    resources.getThreads().addAll(snrDriver.getThreads());
                }
                catch (CreatingException ex) {
                    CommonDriverFactory.onCreatingError(clientInterface, (short)20, conf.getDriver(), conf.getPort(), (Exception)((Object)ex));
                }
            } else {
                log.info((Object)"Sensor is not active");
            }
        } else {
            log.info((Object)"Sensors section or options is not found");
        }
    }

    private static void setPMSensorListener(Device device, ClientInterface clientInterface) {
        List sensors = device.getSensors();
        if (sensors != null) {
            log.info((Object)("Driver contains " + sensors.size() + " sensor(s)"));
            for (Sensor s : sensors) {
                s.addListener((SensorsListener)new PMSensorListener(clientInterface));
            }
        }
    }
}

