/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.hdw;

import fxterm.app.id.LoggerId;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.currency.set.DenominationSet;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.srv.connector.ws.stub.CashTransfer;
import ru.softlogic.storage.cash.StoreListener;
import ru.softlogic.storage.cash.Transfer;

public class AppTransferListener
implements StoreListener {
    private final DeviceId deviceId;
    private final ClientInterface clientInterface;
    private final Logger log = LoggerId.APP;

    public AppTransferListener(DeviceId deviceId, ClientInterface clientInterface) {
        if (deviceId == null) {
            throw new NullPointerException("DeviceId is null");
        }
        if (clientInterface == null) {
            throw new NullPointerException("ClientInterface is null");
        }
        this.deviceId = deviceId;
        this.clientInterface = clientInterface;
    }

    public void onTransfers(List<Transfer> transfers) {
        this.log.info((Object)("Add transfers to queue: " + transfers));
        LinkedList<CashTransfer> list = new LinkedList<CashTransfer>();
        for (Transfer tf : transfers) {
            DenominationSet ds = tf.getCounts();
            for (Map.Entry entry : ds.getCounts().entrySet()) {
                CashTransfer cashTransfer = new CashTransfer(new Date(), this.deviceId.getDeviceClass(), this.deviceId.getNumber(), tf.getBoxFrom(), tf.getBoxTo(), ((Denomination)entry.getKey()).getId(), ((Integer)entry.getValue()).intValue());
                list.add(cashTransfer);
            }
        }
        this.clientInterface.putTransfers(list);
    }
}

