/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.disk;

import fxterm.app.id.LoggerId;
import fxterm.core.disk.BadPermissionWalker;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.system.util.DaemonUtil;
import ru.softlogic.system.util.OsDetector;
import ru.softlogic.system.util.PathUtils;

public class ErrorProcessor
implements Runnable {
    private ClientInterface clientInterface;

    public ErrorProcessor(ClientInterface clientInterface) {
        if (clientInterface == null) {
            throw new NullPointerException("clientInterface");
        }
        this.clientInterface = clientInterface;
    }

    @Override
    public void run() {
        File internet;
        List res = DaemonUtil.getDumps();
        Logger log = LoggerId.APP;
        for (File f : res) {
            log.info((Object)("Found java dump: " + f.getAbsolutePath()));
        }
        if (res.size() > 1) {
            this.clientInterface.sendEvent(new Event[]{new Event(EventType.SoftwareFault, "error dump count=" + (res.size() - 1))});
            for (int i = 0; i < res.size() - 1; ++i) {
                File f;
                f = (File)res.get(i);
                if (f.delete()) continue;
                f.deleteOnExit();
            }
        }
        try {
            log.info((Object)"Check permissions");
            BadPermissionWalker bpw = new BadPermissionWalker();
            LinkedList<File> files = bpw.getFiles(PathUtils.getFilePath((String)"/"));
            log.info((Object)"Check complete");
            if (!files.isEmpty()) {
                log.info((Object)"Wrong permission: ");
                for (File f : files) {
                    log.info((Object)("    " + f.getAbsolutePath()));
                }
                log.info((Object)"-");
                this.clientInterface.sendEvent(new Event[]{new Event(EventType.SoftwareFault, "Wrong permission: " + files)});
            } else {
                log.info((Object)"System has no problem");
            }
        }
        catch (IOException ex) {
            log.info((Object)"Error on process files", (Throwable)ex);
        }
        if (OsDetector.current() == 1 && (internet = new File("/etc/ppp/peers/internet")).exists()) {
            try {
                List content = FileUtils.readLines((File)internet);
                if (content.size() > 1) {
                    log.info((Object)"Process /etc/ppp/peers/internet");
                    String port = (String)content.get(1);
                    log.info((Object)("Pppd port: " + port));
                    List conf = FileUtils.readLines((File)PathUtils.getFilePath((String)"/conf.xml"));
                    for (String str : conf) {
                        if (!str.contains(port) || !str.contains("<modem")) continue;
                        log.warn((Object)"Pppd serial port defined in conf.xml");
                        LoggerId.START.warn((Object)"Pppd serial port defined in conf.xml");
                    }
                }
                log.info((Object)"Done");
            }
            catch (IOException ex) {
                log.error((Object)("Error on process pppd port: " + ex.getMessage()));
            }
        }
    }
}

