/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.disk;

import fxterm.app.id.LoggerId;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.system.util.PathUtils;

public class DiskObserver
implements Runnable {
    private static final long DAY = 86400000L;
    private ClientInterface clientInterface;
    private final Logger log = LoggerId.APP;

    public DiskObserver(ClientInterface clientInterface) {
        if (clientInterface == null) {
            throw new IllegalArgumentException("ClientInterface is null");
        }
        this.clientInterface = clientInterface;
    }

    @Override
    public void run() {
        Date dt = new Date();
        Enumeration en = Logger.getRootLogger().getLoggerRepository().getCurrentLoggers();
        while (en.hasMoreElements()) {
            Logger l = (Logger)en.nextElement();
            l.info((Object)("New day has come: " + dt));
        }
        File file = PathUtils.getFilePath((String)"/");
        this.clientInterface.sendSpace((int)(file.getUsableSpace() / 0x100000L));
        this.cleanDirectory(PathUtils.getPath((String)"/log/add/"));
        this.cleanDirectory(PathUtils.getPath((String)"/log/disp/"));
        this.cleanDirectory(PathUtils.getPath((String)"/log/"));
        this.compressFiles(PathUtils.getPath((String)"/log/add/"));
        this.compressFiles(PathUtils.getPath((String)"/log/disp/"));
        this.compressFiles(PathUtils.getPath((String)"/log/"));
    }

    private void cleanDirectory(String path) {
        File[] fs;
        long now = System.currentTimeMillis();
        int count = 0;
        File dir = new File(path);
        if (dir.isDirectory() && (fs = dir.listFiles()) != null) {
            for (File f : fs) {
                if (f == null || !f.isFile() || now - f.lastModified() <= 7776000000L) continue;
                if (!f.delete()) {
                    f.deleteOnExit();
                }
                ++count;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void compressFiles(String dir) {
        byte[] buf = new byte[1000];
        File[] files = new File(dir).listFiles(pathname -> pathname.isFile() && pathname.getAbsolutePath().contains(".log.") && !pathname.getAbsolutePath().endsWith(".zip"));
        if (files == null) return;
        if (files.length <= 0) return;
        File[] fileArray = files;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            ZipOutputStream zos = null;
            try {
                block19: {
                    zos = new ZipOutputStream(new FileOutputStream(f.getAbsolutePath() + ".zip"));
                    zos.setLevel(9);
                    ZipEntry ze = new ZipEntry(f.getName() + ".txt");
                    BufferedInputStream is = null;
                    try {
                        int read;
                        zos.putNextEntry(ze);
                        is = new BufferedInputStream(new FileInputStream(f));
                        while ((read = ((InputStream)is).read(buf)) >= 0) {
                            zos.write(buf, 0, read);
                        }
                        IOUtils.closeQuietly((InputStream)is);
                    }
                    catch (IOException ex) {
                        this.log.info((Object)"Error on add entity", (Throwable)ex);
                        break block19;
                    }
                    try {
                        zos.closeEntry();
                    }
                    catch (IOException iOException) {}
                    break block19;
                    finally {
                        IOUtils.closeQuietly(is);
                        try {
                            zos.closeEntry();
                        }
                        catch (IOException iOException) {}
                    }
                }
                if (!f.delete()) {
                    f.deleteOnExit();
                }
                IOUtils.closeQuietly((OutputStream)zos);
            }
            catch (FileNotFoundException ex) {
                this.log.info((Object)"Error on create acrh", (Throwable)ex);
            }
            finally {
                IOUtils.closeQuietly(zos);
            }
            ++n2;
        }
    }
}

