/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.cmd;

import fxterm.app.FxEnv;
import fxterm.core.cmd.SendEmailHandler;
import fxterm.core.hdw.bvr.oper.NewKeeper2;
import fxterm.core.menu.GroupByServiceIdVisitor;
import fxterm.core.menu.MenuUtils;
import fxterm.module.ModuleStore;
import fxterm.session.Session;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.io.IOUtils;
import plfx.util.TerminalPlatform;
import ru.softlogic.reference.References;
import ru.softlogic.reference.point.Point;
import ru.softlogic.reference.service.ServiceType;
import ru.softlogic.srv.api.command.Command;
import ru.softlogic.srv.api.command.CommandResultType;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.storage.io.SetDataStore;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.system.util.ThreadUtil;

public class SendScreenShotServiceHandler
extends SendEmailHandler {
    public SendScreenShotServiceHandler(ClientInterface server, SetDataStore<Command> store) {
        super(server, store);
    }

    @Override
    protected String getRecipient(Command cmd) {
        return cmd.getParam1();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long fill(MimeMessage message, Command cmd) throws MessagingException {
        Point point = References.getPoint();
        String serviceId = cmd.getParam2();
        GroupByServiceIdVisitor gbsiv = new GroupByServiceIdVisitor(Integer.parseInt(serviceId));
        MenuUtils.processMenu(gbsiv);
        ServiceType st = gbsiv.getServiceType();
        if (st == null) {
            this.log.error((Object)("\u0421\u0435\u0440\u0432\u0438\u0441\u0430 \u0441 id= " + serviceId + " \u043d\u0435\u0442 \u0432 \u043c\u0435\u043d\u044e \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b\u0430"));
            this.updateCommand(cmd, CommandResultType.BadParams, "Service with id= " + serviceId + " not found in point menu");
        }
        try {
            NewKeeper2 k;
            long t = System.currentTimeMillis();
            if (ModuleStore.getModule().getType() != 1) {
                this.updateCommand(cmd, CommandResultType.Ok, "\u041e\u0436\u0438\u0434\u0430\u0435\u043c \u043d\u0435\u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0438 \u043d\u0430 \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b\u0435");
            }
            while (ModuleStore.getModule().getType() != 1 || (k = Session.getPayEnv().getKeeper()) != null && k.getOut() != null && !k.getOut().isEmpty()) {
                if (System.currentTimeMillis() - t > 600000L) {
                    throw new Exception("Did not wait for inactivity at the terminal");
                }
                Thread.sleep(500L);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
            this.updateCommand(cmd, CommandResultType.BadParams, e.getMessage());
        }
        this.log.info((Object)"\u041e\u0442\u043a\u0440\u044b\u0432\u0430\u0435\u043c \u043f\u0430\u043f\u043a\u0443");
        Session.getPaymentAction().update();
        TerminalPlatform.runLater(() -> FxEnv.getMenuEngine().onGroup(st, 0));
        this.log.info((Object)"\u0416\u0434\u0435\u043c 2 \u0441\u0435\u043a, \u043f\u043e\u043a\u0430 \u043e\u0442\u043a\u0440\u043e\u0435\u0442\u0441\u044f \u043d\u0443\u0436\u043d\u0430\u044f \u043f\u0430\u043f\u043a\u0430");
        ThreadUtil.sleep((long)2000L);
        this.log.info((Object)"\u0414\u0435\u043b\u0430\u0435\u043c \u0441\u043d\u0438\u043c\u043e\u043a \u044d\u043a\u0440\u0430\u043d\u0430");
        BufferedImage screenShot = null;
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] screens = ge.getScreenDevices();
            if (screens == null || screens[0] == null) {
                throw new Exception("Screen not found");
            }
            Robot robotForScreen = new Robot(screens[0]);
            Rectangle screenBounds = screens[0].getDefaultConfiguration().getBounds();
            screenBounds.x = 0;
            screenBounds.y = 0;
            screenShot = robotForScreen.createScreenCapture(screenBounds);
            if (screenShot.getWidth() != 800) {
                Image im = screenShot.getScaledInstance(800, screenShot.getHeight() * 800 / screenShot.getWidth(), 4);
                screenShot = new BufferedImage(im.getWidth(null), im.getHeight(null), 1);
                Graphics2D bGr = screenShot.createGraphics();
                bGr.drawImage(im, 0, 0, null);
                bGr.dispose();
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043d\u044f\u0442\u0438\u044f \u0441\u043a\u0440\u0438\u043d\u0448\u043e\u0442\u0430", (Throwable)ex);
            this.updateCommand(cmd, CommandResultType.BadParams, ex.getMessage());
            throw new MessagingException("Error on screen capture", ex);
        }
        try {
            File file;
            MimeMultipart multipart;
            block19: {
                multipart = new MimeMultipart();
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                file = new File(PathUtils.getPath((String)"/data/screenshot/"), "servicescreen.jpg");
                this.log.info((Object)("\u041e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u0435\u043c: " + file));
                ImageOutputStream ios = null;
                try {
                    ios = ImageIO.createImageOutputStream(file);
                    Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpg");
                    ImageWriter writer = iter.next();
                    if (writer != null) {
                        try {
                            ImageWriteParam iwp = writer.getDefaultWriteParam();
                            iwp.setCompressionMode(2);
                            iwp.setCompressionQuality(0.75f);
                            writer.setOutput(ios);
                            writer.write(null, new IIOImage(screenShot, null, null), iwp);
                            this.log.info((Object)"\u0423\u0441\u043f\u0435\u0445, \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0435\u043c \u0432 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435");
                            FileDataSource source = new FileDataSource(file);
                            messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
                            messageBodyPart.setFileName("servicescreen.jpg");
                            multipart.addBodyPart((BodyPart)messageBodyPart);
                            this.log.info((Object)"\u0423\u0441\u043f\u0435\u0448\u043d\u043e");
                            break block19;
                        }
                        finally {
                            writer.dispose();
                        }
                    }
                    throw new MessagingException("Writer for jpeg-format is not found");
                }
                finally {
                    IOUtils.closeQuietly((Closeable)ios);
                }
            }
            message.setContent((Multipart)multipart);
            message.setSubject("\u0421\u043a\u0440\u0438\u043d\u0448\u043e\u0442 \u043f\u0430\u043f\u043a\u0438 \u0441 \u0441\u0435\u0440\u0432\u0438\u0441\u043e\u043c [" + new SimpleDateFormat("yyyy-MM-dd hh:mm").format(new Date()) + "], \u0442\u043e\u0447\u043a\u0430: " + (point != null ? point.getId() + "/" + point.getName() : "<\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e>") + ",comment=" + cmd.getComment(), "utf-8");
            this.setFile(message, file, "servicescreen.jpg");
            return file.length();
        }
        catch (Exception ex) {
            throw new MessagingException("Error on save screenshot", ex);
        }
    }
}

