/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.cmd;

import fxterm.core.cmd.ArchBuilder;
import fxterm.core.cmd.SendEmailHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.io.FileUtils;
import ru.softlogic.reference.References;
import ru.softlogic.reference.point.Point;
import ru.softlogic.srv.api.command.Command;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.storage.io.SetDataStore;
import ru.softlogic.system.util.OsDetector;

class SendNetStatHandler
extends SendEmailHandler {
    private static final String STAT_DIR = "/var/lib/vnstat";

    public SendNetStatHandler(ClientInterface server, SetDataStore<Command> store) {
        super(server, store);
    }

    @Override
    protected long fill(MimeMessage message, Command cmd) throws MessagingException {
        if (OsDetector.current() != 1) {
            throw new MessagingException("Windows is not supported");
        }
        File arc = null;
        File tmpDir = null;
        try {
            tmpDir = Files.createTempDirectory("sl-netstat", new FileAttribute[0]).toFile();
            this.copyStatDirectory(new File(STAT_DIR), tmpDir);
            if (tmpDir.listFiles() == null || tmpDir.listFiles().length == 0) {
                throw new MessagingException("No files to send");
            }
            Point point = References.getPoint();
            String title = "Network stat, kiosk: " + point.getId() + "/" + point.getName() + ", localtime=" + new Date();
            arc = this.archStatDirectory(tmpDir, title);
            if (arc == null) {
                this.log.info((Object)"Archive empty");
                throw new MessagingException("No data");
            }
            this.log.info((Object)("File for download: " + arc + ", size=" + arc.length() / 1024L + " Kb"));
            message.setSubject(title, "utf-8");
            this.setFile(message, arc, "netstat_" + References.getPoint().getId() + ".zip");
            long l = arc.length();
            return l;
        }
        catch (IOException | MessagingException ex) {
            this.log.error((Object)"Error sending network statistics", ex);
            throw new MessagingException(ex.getClass() + ":" + this.trim(ex.getMessage()) + "," + (arc == null ? "" : " size=" + String.format("%.3f", Float.valueOf((float)arc.length() / 1024.0f)) + " Kb"));
        }
        finally {
            try {
                if (tmpDir != null && tmpDir.exists()) {
                    FileUtils.deleteDirectory((File)tmpDir);
                }
            }
            catch (IOException ex) {
                this.log.error((Object)ex);
            }
        }
    }

    @Override
    protected String getRecipient(Command cmd) {
        return cmd.getParam1();
    }

    private void copyStatDirectory(File statDir, File tmpDir) throws MessagingException {
        File[] listFiles;
        this.log.info((Object)("Tmp dir " + tmpDir.getAbsolutePath()));
        this.log.info((Object)("Stat dir " + statDir));
        if (!statDir.exists()) {
            throw new MessagingException("Stat directory not exist");
        }
        for (File f : listFiles = statDir.listFiles()) {
            if (!f.isFile() || f.getName().equals("lo")) continue;
            File readFile = new File(tmpDir, f.getName() + ".txt");
            try (PrintWriter pw = new PrintWriter(readFile);){
                Process proc = Runtime.getRuntime().exec(new String[]{"vnstat", "-i", f.getName(), "-d"});
                proc.waitFor();
                try (BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));){
                    String str;
                    while ((str = br.readLine()) != null) {
                        pw.println(str);
                    }
                }
                catch (Exception ex) {
                    this.log.error((Object)ex);
                }
            }
            catch (Exception ex) {
                this.log.error((Object)ex);
            }
        }
    }

    private File archStatDirectory(File tmpDir, String title) {
        File arc = null;
        try {
            ArchBuilder archBuilder = new ArchBuilder();
            archBuilder.setLabel(title);
            for (File f : tmpDir.listFiles()) {
                this.addEntry(archBuilder, f.getName(), f);
            }
            arc = archBuilder.finish();
        }
        catch (IOException ex) {
            this.log.error((Object)"Error in the formation of an archive", (Throwable)ex);
        }
        return arc;
    }

    private void addEntry(ArchBuilder ab, String name, File file) throws IOException {
        if (file.exists()) {
            this.log.info((Object)("Add: " + file.getAbsolutePath()));
            ab.addEntry(name, file.getAbsolutePath());
        } else {
            this.log.info((Object)"File not found");
        }
    }
}

