/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.cmd;

import fxterm.core.cmd.BadParamsException;
import fxterm.core.cmd.BaseCmdHandler;
import fxterm.core.cmd.MailAuthenticator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import ru.softlogic.reference.References;
import ru.softlogic.reference.email.Auth;
import ru.softlogic.srv.api.command.Command;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.storage.io.SetDataStore;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.system.util.ThreadUtil;

abstract class SendEmailHandler
extends BaseCmdHandler {
    public SendEmailHandler(ClientInterface server, SetDataStore<Command> store) {
        super(server, store);
    }

    @Override
    protected void _execute(Command cmd) throws BadParamsException {
        String rcpt = this.getRecipient(cmd);
        if (rcpt == null || rcpt.isEmpty()) {
            throw new BadParamsException("Recipient is not set: " + rcpt);
        }
        try {
            this.log.info((Object)"Create message");
            MimeMessage mm = this.createMessage(rcpt);
            this.log.info((Object)"Done, fill message");
            long len = this.fill(mm, cmd);
            this.log.info((Object)("Done, attachment size=" + len + ", send message"));
            this.sendMessage(mm);
            this.toSuccess(cmd, "size=" + String.format("%.1f", Float.valueOf((float)len / 1024.0f)) + " kB");
        }
        catch (IOException | MessagingException ex) {
            this.toError(cmd, (Exception)ex);
        }
    }

    private MimeMessage createMessage(String rcpt) throws IOException, BadParamsException, MessagingException {
        Auth auth = References.getAuth();
        if (auth == null) {
            throw new BadParamsException("Auth params are not set");
        }
        if (rcpt == null || rcpt.isEmpty()) {
            throw new BadParamsException("E-mail is not set");
        }
        Properties props = new Properties();
        if (auth.getEmailSettings() != null && auth.getEmailSettings().trim().length() > 0) {
            this.log.info((Object)"Load properties from references: ");
            props.load(new StringReader(auth.getEmailSettings().replace("\\n", "\n")));
        } else {
            this.log.info((Object)"Load properties from file");
            try (FileInputStream is = new FileInputStream(PathUtils.getFilePath((String)"/res/system//mail-server.properties"));){
                props.load(is);
            }
        }
        Session session = Session.getDefaultInstance((Properties)props, (Authenticator)new MailAuthenticator(auth));
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(auth.getUser()));
        message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(rcpt.trim()));
        return message;
    }

    private void sendMessage(MimeMessage message) throws MessagingException {
        for (int i = 0; i < 5; ++i) {
            this.log.info((Object)("Try to send email, attempt " + i));
            try {
                Transport.send((Message)message);
                this.log.info((Object)"Message has been sent successfully");
                break;
            }
            catch (MessagingException ex) {
                this.log.error((Object)"Failure", (Throwable)ex);
                if (i >= 4) {
                    throw ex;
                }
                this.log.info((Object)"Sleep 20 seconds");
                ThreadUtil.sleep((long)20000L);
                continue;
            }
        }
    }

    protected void setFile(MimeMessage message, File file, String name) throws MessagingException {
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        FileDataSource source = new FileDataSource(file);
        messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
        messageBodyPart.setFileName(name);
        multipart.addBodyPart((BodyPart)messageBodyPart);
        message.setContent((Multipart)multipart);
    }

    protected abstract String getRecipient(Command var1);

    protected abstract long fill(MimeMessage var1, Command var2) throws MessagingException;
}

