/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.cmd;

import fxterm.app.id.LoggerId;
import fxterm.module.ModuleStore;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javafx.embed.swing.SwingFXUtils;
import javafx.stage.Stage;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.apache.log4j.Logger;
import plfx.util.TerminalPlatform;
import ru.softlogic.system.util.PathUtils;

public class ScreenshotMaker {
    private final Stage stage;
    private final Logger log = LoggerId.APP;
    private final Object sync = new Object();
    private Exception ex;
    private File file;
    private boolean finished = false;

    public ScreenshotMaker(Stage stage) {
        this.stage = stage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File makeScreenshot() throws Exception {
        this.log.info((Object)"Need to make main menu screenshot");
        this.ex = null;
        this.file = null;
        try {
            int type;
            for (int i = 0; i < 300 && (type = ModuleStore.getModule().getType()) != 1 && type != 0; ++i) {
            }
            TerminalPlatform.runLater((Runnable)new ScreenshotRunnable());
            Object i = this.sync;
            synchronized (i) {
                if (!this.finished) {
                    this.sync.wait();
                }
            }
            if (this.ex != null) {
                throw this.ex;
            }
            return this.file;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new IOException(ie);
        }
    }

    private class ScreenshotRunnable
    implements Runnable {
        private ScreenshotRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block27: {
                Object image;
                try {
                    ScreenshotMaker.this.log.info((Object)"Make screenshot");
                    image = ScreenshotMaker.this.stage.getScene().snapshot(null);
                    BufferedImage bImage = SwingFXUtils.fromFXImage((javafx.scene.image.Image)image, null);
                    if (bImage.getWidth() != 800) {
                        ScreenshotMaker.this.log.info((Object)"Scale image");
                        Image im = bImage.getScaledInstance(800, bImage.getHeight() * 800 / bImage.getWidth(), 4);
                        bImage = new BufferedImage(im.getWidth(null), im.getHeight(null), 1);
                        Graphics2D bGr = bImage.createGraphics();
                        bGr.drawImage(im, 0, 0, null);
                        bGr.dispose();
                    }
                    ScreenshotMaker.this.log.info((Object)"Done, save it to file");
                    ScreenshotMaker.this.file = new File(PathUtils.getPath((String)"/data/screenshot/"), "main.jpg");
                    ImageOutputStream ios = null;
                    try {
                        ios = ImageIO.createImageOutputStream(ScreenshotMaker.this.file);
                        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpg");
                        ImageWriter writer = iter.next();
                        if (writer != null) {
                            try {
                                ImageWriteParam iwp = writer.getDefaultWriteParam();
                                iwp.setCompressionMode(2);
                                iwp.setCompressionQuality(0.75f);
                                writer.setOutput(ios);
                                writer.write(null, new IIOImage(bImage, null, null), iwp);
                                ScreenshotMaker.this.log.info((Object)"Success");
                                break block27;
                            }
                            finally {
                                writer.dispose();
                            }
                        }
                        throw new Exception("Writer for jpeg-format is not found");
                    }
                    finally {
                        if (ios != null) {
                            try {
                                ios.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                catch (Throwable tw) {
                    ScreenshotMaker.this.ex = new Exception(tw);
                }
                finally {
                    image = ScreenshotMaker.this.sync;
                    synchronized (image) {
                        ScreenshotMaker.this.finished = true;
                        ScreenshotMaker.this.sync.notifyAll();
                    }
                }
            }
        }
    }
}

