/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.cmd;

import fxterm.core.cmd.SendEmailHandler;
import java.awt.AWTException;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.io.IOUtils;
import ru.softlogic.reference.References;
import ru.softlogic.reference.point.Point;
import ru.softlogic.srv.api.command.Command;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.storage.io.SetDataStore;
import ru.softlogic.system.util.PathUtils;

class ScreensEmailHandler
extends SendEmailHandler {
    public ScreensEmailHandler(ClientInterface server, SetDataStore<Command> store) {
        super(server, store);
    }

    @Override
    protected String getRecipient(Command cmd) {
        return cmd.getParam1();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long fill(MimeMessage message, Command cmd) throws MessagingException {
        try {
            Point point = References.getPoint();
            LinkedList<BufferedImage> screenShots = new LinkedList<BufferedImage>();
            try {
                GraphicsDevice[] screens;
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                for (GraphicsDevice screen : screens = ge.getScreenDevices()) {
                    Robot robotForScreen = new Robot(screen);
                    Rectangle screenBounds = screen.getDefaultConfiguration().getBounds();
                    screenBounds.x = 0;
                    screenBounds.y = 0;
                    BufferedImage bi = robotForScreen.createScreenCapture(screenBounds);
                    if (bi.getWidth() != 800) {
                        this.log.info((Object)"Scale image");
                        Image im = bi.getScaledInstance(800, bi.getHeight() * 800 / bi.getWidth(), 4);
                        bi = new BufferedImage(im.getWidth(null), im.getHeight(null), 1);
                        Graphics2D bGr = bi.createGraphics();
                        bGr.drawImage(im, 0, 0, null);
                        bGr.dispose();
                    }
                    screenShots.add(bi);
                }
            }
            catch (AWTException | HeadlessException ex) {
                throw new MessagingException("Error on screen capture", ex);
            }
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            long size = 0L;
            for (int i = 0; i < screenShots.size(); ++i) {
                File file;
                block14: {
                    String name = Integer.toString(i) + ".jpg";
                    file = new File(PathUtils.getPath((String)"/data/screenshot/"), name);
                    this.log.info((Object)("Process: " + file));
                    ImageOutputStream ios = null;
                    try {
                        ios = ImageIO.createImageOutputStream(file);
                        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpg");
                        ImageWriter writer = iter.next();
                        if (writer != null) {
                            try {
                                ImageWriteParam iwp = writer.getDefaultWriteParam();
                                iwp.setCompressionMode(2);
                                iwp.setCompressionQuality(0.75f);
                                writer.setOutput(ios);
                                writer.write(null, new IIOImage((RenderedImage)screenShots.get(i), null, null), iwp);
                                this.log.info((Object)"Success, add it to message");
                                FileDataSource source = new FileDataSource(file);
                                messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
                                messageBodyPart.setFileName(name);
                                multipart.addBodyPart((BodyPart)messageBodyPart);
                                this.log.info((Object)"Success");
                                break block14;
                            }
                            finally {
                                writer.dispose();
                            }
                        }
                        throw new MessagingException("Writer for jpeg-format is not found");
                    }
                    finally {
                        IOUtils.closeQuietly((Closeable)ios);
                    }
                }
                size += file.length();
            }
            message.setContent((Multipart)multipart);
            message.setSubject("Screenshots, point " + (point != null ? Integer.valueOf(point.getId()) : "-"), "utf-8");
            return size;
        }
        catch (Exception ex) {
            throw new MessagingException("Error on save screenshot", ex);
        }
    }
}

