/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.cmd;

import fxterm.app.FxEnv;
import fxterm.core.cmd.ScreenshotMaker;
import fxterm.core.cmd.SendEmailHandler;
import java.io.File;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import ru.softlogic.reference.References;
import ru.softlogic.reference.point.Point;
import ru.softlogic.srv.api.command.Command;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.storage.io.SetDataStore;

class ScreenEmailHandler
extends SendEmailHandler {
    public ScreenEmailHandler(ClientInterface server, SetDataStore<Command> store) {
        super(server, store);
    }

    @Override
    protected String getRecipient(Command cmd) {
        return cmd.getParam1();
    }

    @Override
    protected long fill(MimeMessage message, Command cmd) throws MessagingException {
        try {
            Point point = References.getPoint();
            ScreenshotMaker sm = new ScreenshotMaker(FxEnv.getPrimaryStage());
            File f = sm.makeScreenshot();
            message.setSubject("Screenshot, point " + (point != null ? Integer.valueOf(point.getId()) : "-"), "utf-8");
            this.setFile(message, f, "main.jpg");
            return f.length();
        }
        catch (Exception ex) {
            throw new MessagingException("Error on save screenshot", ex);
        }
    }
}

