/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.cmd;

import fxterm.core.cmd.ArchBuilder;
import fxterm.core.cmd.SendEmailHandler;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import ru.softlogic.reference.References;
import ru.softlogic.reference.point.Point;
import ru.softlogic.srv.api.command.Command;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.storage.io.SetDataStore;
import ru.softlogic.system.util.PathUtils;

class PayLogsEmailHandler
extends SendEmailHandler {
    private final SimpleDateFormat dp = new SimpleDateFormat("yyyy-MM-dd");
    private final SimpleDateFormat df = new SimpleDateFormat("yyMMdd");

    public PayLogsEmailHandler(ClientInterface server, SetDataStore<Command> store) {
        super(server, store);
    }

    @Override
    protected String getRecipient(Command cmd) {
        return cmd.getParam2();
    }

    @Override
    protected long fill(MimeMessage message, Command cmd) throws MessagingException {
        Date d2;
        Date d1;
        String dateFrom = cmd.getParam1();
        String dateTo = cmd.getParam3();
        if (dateTo == null) {
            dateTo = dateFrom;
        }
        try {
            d1 = this.dp.parse(dateFrom);
            d2 = this.dp.parse(dateTo);
        }
        catch (ParseException ex) {
            throw new MessagingException("Error on parce date", (Exception)ex);
        }
        if (d1.after(d2)) {
            throw new MessagingException("DateFrom is greater than DateTo");
        }
        Point point = References.getPoint();
        String label = MessageFormat.format(this.getLabel(), dateFrom, dateTo, point.getId(), point.getName(), cmd.getComment());
        message.setSubject(label, "utf-8");
        ArchBuilder archBuilder = null;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(d1);
        try {
            archBuilder = new ArchBuilder();
            archBuilder.setLabel(label + ", localtime=" + new Date());
            while (cal.getTime().compareTo(d2) <= 0) {
                Date dl = cal.getTime();
                String dls = this.dp.format(dl);
                this.log.info((Object)("Add logs " + dls));
                String suffix = "." + dls;
                if (this.dp.format(new Date()).equals(dls)) {
                    suffix = "";
                }
                for (String file : this.getNames()) {
                    this.addEntry(archBuilder, file.replace("add/", "").replace(".log", "") + suffix + ".txt", File.separator + "log" + File.separator + file + suffix);
                }
                ((Calendar)cal).add(5, 1);
            }
            if (this.isAddConf()) {
                this.addEntry(archBuilder, "conf.xml", "/conf.xml");
            }
            File file = archBuilder.finish();
            this.setFile(message, file, "logs_" + point.getId() + "_" + this.df.format(d1) + "-" + this.df.format(d2) + ".zip");
            long l = file.length();
            return l;
        }
        catch (IOException ex) {
            throw new MessagingException("Error on build arc", (Exception)ex);
        }
        finally {
            if (archBuilder != null) {
                archBuilder.close();
            }
        }
    }

    protected String[] getNames() {
        return new String[]{"pay.log", "coin.log", "cashin.log"};
    }

    protected boolean isAddConf() {
        return false;
    }

    protected String getLabel() {
        return "Pay logs for [{0},{1}], point: {2}, comment: {4}";
    }

    private void addEntry(ArchBuilder ab, String name, String path) throws IOException {
        this.log.info((Object)("Needs to add: " + name + ", path=" + path));
        File regular = PathUtils.getFilePath((String)path);
        File zip = PathUtils.getFilePath((String)(path + ".zip"));
        this.log.info((Object)("Search regular file: " + regular));
        if (regular.exists()) {
            this.log.info((Object)("Add: " + regular));
            ab.addEntry(name, regular.getAbsolutePath());
        } else if (zip.exists()) {
            this.log.info((Object)"Regular file is not found, search arch");
            this.log.info((Object)("Add: " + zip));
            ab.addEntry(name + ".zip", zip.getAbsolutePath());
        } else {
            this.log.info((Object)"File is not found");
        }
    }
}

