/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.cmd;

import fxterm.core.cmd.AllLogsEmailHandler;
import fxterm.core.cmd.CheckDiskHandler;
import fxterm.core.cmd.ClearUpdateHandler;
import fxterm.core.cmd.CmdHandler;
import fxterm.core.cmd.ExecHandler;
import fxterm.core.cmd.ExecuteUssdHandler;
import fxterm.core.cmd.HdwEmailHandler;
import fxterm.core.cmd.JavaLogsEmailHandler;
import fxterm.core.cmd.PayLogsEmailHandler;
import fxterm.core.cmd.PowerOffHandler;
import fxterm.core.cmd.RebootHandler;
import fxterm.core.cmd.ScreenEmailHandler;
import fxterm.core.cmd.ScreensEmailHandler;
import fxterm.core.cmd.SendNetStatHandler;
import fxterm.core.cmd.SendProcessHendler;
import fxterm.core.cmd.SendScreenShotServiceHandler;
import fxterm.core.cmd.UpdateFmwHandler;
import fxterm.core.cmd.UpdateJavaHandler;
import fxterm.core.cmd.WrongCmdHandler;
import ru.softlogic.srv.api.command.Command;
import ru.softlogic.srv.api.command.CommandType;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.storage.io.SetDataStore;

class HandlerFactory {
    private HandlerFactory() {
    }

    public static CmdHandler createHandler(CommandType type, ClientInterface server, SetDataStore<Command> store) {
        if (type == null) {
            return new WrongCmdHandler(server, store);
        }
        switch (type) {
            case Reboot: {
                return new RebootHandler(server, store);
            }
            case ClearUpdate: {
                return new ClearUpdateHandler(server, store);
            }
            case PowerOff: {
                return new PowerOffHandler(server, store);
            }
            case CheckDisk: {
                return new CheckDiskHandler(server, store);
            }
            case ExecuteCmd: {
                return new ExecHandler(server, store);
            }
            case UpdateJava: {
                return new UpdateJavaHandler(server, store);
            }
            case UpdateFirmware: {
                return new UpdateFmwHandler(server, store);
            }
            case SendLog: {
                return new PayLogsEmailHandler(server, store);
            }
            case SendAllLog: {
                return new AllLogsEmailHandler(server, store);
            }
            case SendScreenShot: {
                return new ScreenEmailHandler(server, store);
            }
            case SendScreenShots: {
                return new ScreensEmailHandler(server, store);
            }
            case SendHardwareInfo: {
                return new HdwEmailHandler(server, store);
            }
            case JavaLog: {
                return new JavaLogsEmailHandler(server, store);
            }
            case ExecuteUSSD: {
                return new ExecuteUssdHandler(server, store);
            }
            case SendNetStat: {
                return new SendNetStatHandler(server, store);
            }
            case Processes: {
                return new SendProcessHendler(server, store);
            }
            case SendScreenShotService: {
                return new SendScreenShotServiceHandler(server, store);
            }
        }
        return new WrongCmdHandler(server, store);
    }
}

