/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.cmd;

import fxterm.app.FxEnv;
import fxterm.core.cmd.BadParamsException;
import fxterm.core.cmd.BaseCmdHandler;
import fxterm.core.net.ppp.DialupSystem;
import fxterm.core.net.ppp.UssdExecuteTask;
import ru.softlogic.srv.api.command.Command;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.storage.io.SetDataStore;

class ExecuteUssdHandler
extends BaseCmdHandler {
    public ExecuteUssdHandler(ClientInterface server, SetDataStore<Command> store) {
        super(server, store);
    }

    @Override
    protected void _execute(Command cmd) throws BadParamsException {
        if (cmd.getParam1() == null || cmd.getParam1().isEmpty()) {
            throw new BadParamsException("USSD is empty");
        }
        DialupSystem dialupSystem = FxEnv.getDialupSystem();
        if (dialupSystem == null) {
            throw new BadParamsException("DialupSystem is not available");
        }
        if (!dialupSystem.hasModem()) {
            throw new BadParamsException("Modem is not installing or configured");
        }
        UssdExecuteTask task = new UssdExecuteTask(cmd);
        dialupSystem.addTask(task);
        try {
            String res = task.getResult();
            this.toSuccess(cmd, res);
        }
        catch (InterruptedException ex) {
            this.toError(cmd, ex);
            Thread.currentThread().interrupt();
        }
    }
}

