/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.cmd;

import fxterm.core.cmd.BadParamsException;
import fxterm.core.cmd.BaseCmdHandler;
import fxterm.core.reboot.SafeReboot;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.DirectoryWalker;
import ru.softlogic.srv.api.command.Command;
import ru.softlogic.srv.api.command.CommandResultType;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.storage.io.SetDataStore;
import ru.softlogic.system.util.PathUtils;

class ExecHandler
extends BaseCmdHandler {
    public ExecHandler(ClientInterface server, SetDataStore<Command> store) {
        super(server, store);
    }

    @Override
    protected void _execute(Command cmd) throws BadParamsException {
        String cmdLine = cmd.getParam1();
        if (cmdLine == null) {
            throw new BadParamsException("Null cmd line");
        }
        this.log.info((Object)("Cmd line: " + cmdLine));
        if ("exit".equals(cmdLine)) {
            this.log.info((Object)"Needs to restart java");
            this.toSuccess(cmd);
            SafeReboot.exit(0, 1);
        } else if ("clearlogs".equals(cmdLine)) {
            try {
                LogsCleaner lc = new LogsCleaner();
                lc.clean(PathUtils.getFilePath((String)"/log/"));
                this.toSuccess(cmd);
            }
            catch (IOException ex) {
                this.toError(cmd, ex);
            }
        } else {
            try {
                this.log.info((Object)"Execute process");
                this.toSuccess(cmd);
                Process p = Runtime.getRuntime().exec(cmdLine);
                if (!p.waitFor(120L, TimeUnit.SECONDS)) {
                    this.log.error((Object)"Execute is too long, destroy");
                    this.updateCommand(cmd, CommandResultType.Error, "Execute is too long, destroy");
                    p.destroy();
                } else {
                    int code = p.exitValue();
                    this.log.info((Object)("Success, exit value: " + code));
                }
            }
            catch (IOException ex) {
                this.toError(cmd, ex);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                this.toError(cmd, ex);
            }
        }
    }

    private class LogsCleaner
    extends DirectoryWalker<File> {
        private LogsCleaner() {
        }

        public void clean(File startDirectory) throws IOException {
            LinkedList results = new LinkedList();
            this.walk(startDirectory, results);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleFile(File file, int depth, Collection<File> results) {
            if (!file.delete()) {
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(file);
                    ExecHandler.this.log.info((Object)("Truncated: " + file));
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                finally {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            } else {
                ExecHandler.this.log.info((Object)("Deleted: " + file));
            }
        }
    }
}

