/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.cmd;

import fxterm.app.SystemProp;
import fxterm.app.id.LoggerId;
import fxterm.core.cmd.CmdHandler;
import fxterm.core.cmd.HandlerFactory;
import org.apache.log4j.Logger;
import ru.softlogic.srv.api.command.Command;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.storage.io.SetDataStore;
import ru.softlogic.system.util.ProcessExecutor;

public class CommandLauncher
implements Runnable {
    private final SetDataStore<Command> commandStore;
    private final ClientInterface clientInterface;
    private final Logger log = LoggerId.APP;

    public CommandLauncher(SetDataStore<Command> commandStore, ClientInterface clientInterface, ProcessExecutor executor) {
        if (commandStore == null) {
            throw new NullPointerException("CommandStore is null");
        }
        if (clientInterface == null) {
            throw new NullPointerException("ClientInterface is null");
        }
        this.commandStore = commandStore;
        this.clientInterface = clientInterface;
    }

    @Override
    public void run() {
        this.log.info((Object)"Start Thread");
        int delay = SystemProp.getCmdLaucherDelay();
        this.log.info((Object)("Sleep " + delay + " seconds"));
        try {
            this.sleep(delay);
            this.log.info((Object)"Start process commands");
            while (!Thread.currentThread().isInterrupted()) {
                for (Command cmd : this.commandStore.get()) {
                    this.log.info((Object)("Process: " + cmd));
                    CmdHandler ch = HandlerFactory.createHandler(cmd.getType(), this.clientInterface, this.commandStore);
                    ch.execute(cmd);
                }
                this.sleep(20);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        this.log.info((Object)"Stop Thread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sleep(int secs) throws InterruptedException {
        CommandLauncher commandLauncher = this;
        synchronized (commandLauncher) {
            this.wait((long)secs * 1000L);
        }
    }
}

