/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.cmd;

import fxterm.app.id.LoggerId;
import fxterm.core.cmd.BadParamsException;
import fxterm.core.cmd.CmdHandler;
import fxterm.core.reboot.SafeReboot;
import java.util.Date;
import org.apache.log4j.Logger;
import ru.softlogic.srv.api.command.Command;
import ru.softlogic.srv.api.command.CommandResult;
import ru.softlogic.srv.api.command.CommandResultType;
import ru.softlogic.srv.api.command.CommandType;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.storage.io.SetDataStore;

abstract class BaseCmdHandler
implements CmdHandler {
    protected final Logger log = LoggerId.APP;
    private final ClientInterface server;
    private final SetDataStore<Command> store;

    public BaseCmdHandler(ClientInterface server, SetDataStore<Command> store) {
        if (server == null) {
            throw new NullPointerException("ClientInterface is null");
        }
        if (store == null) {
            throw new NullPointerException("CommandStore is null");
        }
        this.server = server;
        this.store = store;
    }

    @Override
    public final void execute(Command cmd) {
        if (cmd.getType() == null) {
            this.updateCommand(cmd, CommandResultType.BadParams, "Type is not set");
        } else if (cmd.getExecuteTill() == null) {
            this.updateCommand(cmd, CommandResultType.BadParams, "ExecuteTill is not set");
        } else if (cmd.getExecuteTill().compareTo(new Date()) < 0) {
            this.updateCommand(cmd, CommandResultType.Timeout, "Current time: " + new Date() + ", max date: " + cmd.getExecuteTill());
        } else {
            try {
                this._execute(cmd);
            }
            catch (BadParamsException ex) {
                this.updateCommand(cmd, CommandResultType.BadParams, ex.getMessage());
            }
        }
    }

    protected void updateCommand(Command cmd, CommandResultType resultType, String comment) {
        this.log.info((Object)("Command result " + resultType + ", comment: " + comment));
        this.server.send(new CommandResult(cmd.getId(), resultType, comment));
        this.store.remove((Object)cmd);
        if (resultType == CommandResultType.Ok && cmd.getType() != CommandType.Reboot) {
            this.log.info((Object)("Needs reboot: " + cmd.isReboot()));
            if (cmd.isReboot()) {
                SafeReboot.reboot(1);
            }
        }
    }

    protected void toError(Command cmd, Exception ex) {
        this.log.error((Object)"Error on process cmd", (Throwable)ex);
        this.updateCommand(cmd, CommandResultType.Error, ex.getClass() + ":" + this.trim(ex.getMessage()));
    }

    protected void toSuccess(Command cmd) {
        this.updateCommand(cmd, CommandResultType.Ok, null);
    }

    protected void toSuccess(Command cmd, String comment) {
        this.updateCommand(cmd, CommandResultType.Ok, comment);
    }

    protected String trim(String str) {
        if (str == null) {
            return null;
        }
        return str.trim().replace("\n", "").replace("\r", "");
    }

    protected abstract void _execute(Command var1) throws BadParamsException;
}

