/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.cmd;

import fxterm.app.id.LoggerId;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class ArchBuilder {
    private File zipFile;
    private ZipOutputStream zos;
    private Logger log = LoggerId.APP;

    public ArchBuilder() throws IOException {
        try {
            this.zipFile = File.createTempFile("softlogic", ".zip");
            this.zos = new ZipOutputStream(new FileOutputStream(this.zipFile));
            this.zos.setLevel(9);
        }
        catch (IOException ex) {
            IOUtils.closeQuietly((OutputStream)this.zos);
            throw new IOException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0432\u0440\u0435\u043c\u0435\u043d\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLabel(String label) {
        if (label != null) {
            ZipEntry ze = new ZipEntry("label.txt");
            try {
                this.zos.putNextEntry(ze);
                this.zos.write(label.getBytes(StandardCharsets.UTF_8), 0, label.getBytes().length);
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    this.zos.closeEntry();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addEntry(String name, String path) throws IOException {
        byte[] buf = new byte[1000];
        File file = new File(path);
        if (!file.canRead()) return;
        ZipEntry ze = new ZipEntry(name);
        BufferedInputStream is = null;
        try {
            int read;
            this.zos.putNextEntry(ze);
            is = new BufferedInputStream(new FileInputStream(path));
            while ((read = ((InputStream)is).read(buf)) >= 0) {
                this.zos.write(buf, 0, read);
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        catch (Exception ex) {
            this.log.error((Object)"\u0421\u0431\u043e\u0439 \u043f\u0440\u0438 \u0443\u043f\u0430\u043a\u043e\u0432\u043a\u0435 \u0444\u0430\u0439\u043b\u0430", (Throwable)ex);
            return;
        }
        try {
            this.zos.closeEntry();
            return;
        }
        catch (Exception exception) {
            return;
        }
        finally {
            IOUtils.closeQuietly(is);
            try {
                this.zos.closeEntry();
            }
            catch (Exception exception) {}
        }
    }

    public File finish() {
        if (this.zos != null) {
            try {
                this.zos.close();
                this.zos = null;
                return this.zipFile;
            }
            catch (IOException ex) {
                this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0438 \u0444\u0430\u0439\u043b\u0430", (Throwable)ex);
            }
        }
        return null;
    }

    public void close() {
        IOUtils.closeQuietly((OutputStream)this.zos);
    }
}

