/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.cash;

import fxterm.app.SystemProp;
import fxterm.core.cash.CompatCashProfile;
import fxterm.session.TextHelper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.hardware.currency.Cash;
import ru.softlogic.hardware.currency.CashProfile;
import ru.softlogic.hardware.currency.CashProfileException;
import ru.softlogic.hardware.currency.Denomination;

public class CompatCashFactory {
    public static CompatCashProfile getProfile(String currency) throws CashProfileException {
        CashProfile cp = Cash.getCashProfile((String)Cash.correctCode((String)currency));
        CashUnit[] bu = CompatCashFactory.convert(cp.getBills(), 3);
        CashUnit[] co = CompatCashFactory.convert(cp.getCoins(), 4);
        return new CompatCashProfile(bu, co);
    }

    public static String getCurrency(String currency) {
        if (TextHelper.isEmpty(currency)) {
            return CompatCashFactory.getSystemCurrency();
        }
        return currency;
    }

    public static String getSystemCurrency() {
        return SystemProp.getDefaultCurrency();
    }

    private static CashUnit[] convert(Denomination[] dens, int type) {
        CashUnit[] cu = new CashUnit[dens.length];
        for (int i = 0; i < dens.length; ++i) {
            Denomination d = dens[i];
            cu[i] = new CashUnit(d.getId(), new Sum(d.getNominal(), d.getCurrency()), type);
        }
        return cu;
    }
}

