/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.adv.stat;

import fxterm.core.adv.stat.AdvStatisticStore;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ru.softlogic.reference.adv.AdvStatistic;
import ru.softlogic.reference.adv.AdvStatisticType;
import ru.softlogic.storage.io.ObjectIO;
import ru.softlogic.storage.io.Serializator;
import ru.softlogic.storage.io.SimpleSerializator;

public class AdvStatHandler {
    private final ObjectIO<AdvStatisticStore> io;
    private AdvStatisticStore store;

    public AdvStatHandler(File file) {
        this.io = new ObjectIO((Serializator)new SimpleSerializator(file));
    }

    public synchronized void addStatistic(int id, AdvStatisticType type) {
        this.check();
        String key = Integer.toString(id) + type;
        AdvStatistic get = this.store.getStat().get(key);
        if (get == null) {
            AdvStatistic as = new AdvStatistic();
            as.setId(id);
            as.setType(type);
            as.setCount(1);
            this.store.getStat().put(key, as);
        } else {
            get.setCount(get.getCount() + 1);
        }
        this.io.write((Serializable)this.store);
    }

    public synchronized List<AdvStatistic> resetStatistics() {
        this.check();
        AdvStatisticStore newStat = new AdvStatisticStore();
        Map<String, AdvStatistic> stat = this.store.getStat();
        LinkedList<AdvStatistic> res = new LinkedList<AdvStatistic>();
        for (AdvStatistic as : stat.values()) {
            as.setFrom(this.store.getFrom());
            as.setTo(newStat.getFrom());
            res.add(as);
        }
        this.store = newStat;
        this.io.write((Serializable)this.store);
        return res;
    }

    public synchronized Date getFrom() {
        this.check();
        return this.store.getFrom();
    }

    private void check() {
        if (this.store == null) {
            this.store = (AdvStatisticStore)this.io.read((Serializable)new AdvStatisticStore());
        }
    }
}

