/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.adv.disig;

import java.io.File;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.disig.impl.Producer;
import ru.softlogic.disig.player.Playlist;
import ru.softlogic.reference.References;
import ru.softlogic.reference.adv.Movie;
import ru.softlogic.system.util.PathUtils;

public class RefPlaylistProducer
implements Producer<Playlist> {
    private final Logger log = Logger.getLogger(RefPlaylistProducer.class);

    public Playlist get() {
        this.log.info((Object)"----------------------------------------------");
        this.log.info((Object)"Try to build ref list");
        LinkedList<ru.softlogic.disig.player.Movie> res = new LinkedList<ru.softlogic.disig.player.Movie>();
        Movie[] movies = References.getMovies();
        LinkedHashMap<Object, Integer> freq = new LinkedHashMap<Object, Integer>();
        if (movies != null && movies.length > 0) {
            this.log.info((Object)("Count of movies: " + movies.length));
            for (Movie m : movies) {
                this.log.info((Object)("Process " + m));
                if (!this.isSuitable(m)) continue;
                this.log.info((Object)"    Add to list");
                freq.put(m, m.getWeight());
            }
            if (!freq.isEmpty()) {
                boolean found;
                this.log.info((Object)"Preprocessing performed, build playlist");
                do {
                    found = false;
                    for (Map.Entry entry : freq.entrySet()) {
                        if ((Integer)entry.getValue() <= 0) continue;
                        ru.softlogic.disig.player.Movie mv = this.convert((Movie)entry.getKey());
                        this.log.info((Object)("    " + mv));
                        found = true;
                        res.add(mv);
                        freq.put(entry.getKey(), (Integer)entry.getValue() - 1);
                    }
                } while (found);
            } else {
                this.log.info((Object)"There are no active movies");
            }
        } else {
            this.log.info((Object)"List is empty");
        }
        this.log.info((Object)"--- Done");
        return new Playlist(res);
    }

    private ru.softlogic.disig.player.Movie convert(Movie movie) {
        return new ru.softlogic.disig.player.Movie(movie.getId(), PathUtils.getFilePath((String)("/content/ad/" + movie.getUrl())), movie.getDuration() * 1000);
    }

    private boolean isSuitable(Movie movie) {
        if (movie.getIdService() != null) {
            this.log.info((Object)"    Movie is not suitable, wrong id-service. Skip");
            return false;
        }
        if (movie.getWeight() < 1 || movie.getWeight() > 10) {
            this.log.info((Object)"    Movie is not suitable, wrong weight. Skip");
            return false;
        }
        Date now = new Date();
        if (movie.getBegin() != null && now.before(movie.getBegin())) {
            this.log.info((Object)"    Movie is not suitable, advertising campaign does not start. Skip");
            return false;
        }
        if (movie.getEnd() != null && now.after(movie.getEnd())) {
            this.log.info((Object)"    Movie is not suitable, advertising campaign ended. Skip");
            return false;
        }
        File f = PathUtils.getFilePath((String)("/content/ad/" + movie.getUrl()));
        if (f.canRead() && f.length() > 100L) {
            return true;
        }
        this.log.info((Object)"    Movie is not suitable, file does not exist or its size is too small. Skip");
        return false;
    }

    public String toString() {
        return "RefPlaylistProducer{}";
    }
}

