/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.adv;

import fxterm.app.id.LoggerId;
import fxterm.core.adv.AdvDescription;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.util.Pair;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import plfx.adv.AdContentType;
import plfx.skin.Skin;
import ru.softlogic.reference.References;
import ru.softlogic.reference.adv.Banner;
import ru.softlogic.reference.adv.Movie;
import ru.softlogic.system.util.PathUtils;

public class AdvStore {
    private static final Logger log = LoggerId.ADV;
    private static final Map<String, Pair<List<Banner>, AtomicInteger>> bannerLists = new ConcurrentHashMap<String, Pair<List<Banner>, AtomicInteger>>();
    private static final Map<String, Pair<List<Movie>, AtomicInteger>> movieLists = new ConcurrentHashMap<String, Pair<List<Movie>, AtomicInteger>>();

    public static AdvDescription getNextBanner(String place, Short idService) {
        Pair playlist = bannerLists.get(Skin.getWorkSkin() + "_" + place + "_" + idService);
        if (playlist == null || playlist.getKey() == null || ((List)playlist.getKey()).isEmpty() || ((AtomicInteger)playlist.getValue()).get() >= ((List)playlist.getKey()).size()) {
            List<Banner> banners = AdvStore.getBannerPlaylist(Skin.getWorkSkin(), place, idService);
            if (banners == null || banners.isEmpty()) {
                return null;
            }
            playlist = new Pair(banners, (Object)new AtomicInteger(0));
            bannerLists.put(Skin.getWorkSkin() + "_" + place + "_" + idService, (Pair<List<Banner>, AtomicInteger>)playlist);
        }
        Banner banner = (Banner)((List)playlist.getKey()).get(((AtomicInteger)playlist.getValue()).getAndIncrement());
        AdvDescription desc = AdvStore.getDescription(banner);
        return desc;
    }

    public static AdvDescription getNextMovie(Short idService) {
        Pair playlist = movieLists.get("" + idService);
        if (playlist == null || playlist.getKey() == null || ((List)playlist.getKey()).isEmpty() || ((AtomicInteger)playlist.getValue()).get() >= ((List)playlist.getKey()).size()) {
            List<Movie> movies = AdvStore.getMoviePlaylist(idService);
            if (movies == null || movies.isEmpty()) {
                return null;
            }
            playlist = new Pair(movies, (Object)new AtomicInteger(0));
            movieLists.put("" + idService, (Pair<List<Movie>, AtomicInteger>)playlist);
        }
        Movie movie = (Movie)((List)playlist.getKey()).get(((AtomicInteger)playlist.getValue()).getAndIncrement());
        AdvDescription desc = AdvStore.getDescription(movie);
        return desc;
    }

    private static AdvDescription getDescription(Banner banner) {
        AdvDescription description = new AdvDescription();
        description.setBanner(banner);
        description.setShowTime(banner.getShowTime());
        String path = banner.getUrl().toLowerCase();
        if (path.endsWith(".png") || path.endsWith(".jpg") || path.endsWith(".jpeg") || path.endsWith(".gif")) {
            description.setContentType(AdContentType.Image);
            description.setPath(PathUtils.getUrlPath((String)("/content/banners/" + banner.getUrl())));
        } else if (path.endsWith(".zip")) {
            description.setContentType(AdContentType.Html);
            description.setPath(PathUtils.getUrlPath((String)("/content/banners/" + FilenameUtils.removeExtension((String)banner.getUrl()) + "/index.html")));
        } else {
            return null;
        }
        return description;
    }

    private static AdvDescription getDescription(Movie movie) {
        AdvDescription description = new AdvDescription();
        description.setMovie(movie);
        String path = movie.getUrl().toLowerCase();
        if (path.endsWith(".png") || path.endsWith(".jpg") || path.endsWith(".jpeg") || path.endsWith(".gif")) {
            description.setContentType(AdContentType.Image);
            description.setPath(movie.getUrl());
        } else if (path.endsWith(".zip")) {
            description.setContentType(AdContentType.Html);
            description.setPath(FilenameUtils.removeExtension((String)movie.getUrl()) + "/index.html");
        } else {
            description.setContentType(AdContentType.Video);
            description.setPath(movie.getUrl());
        }
        return description;
    }

    private static List<Banner> getBannerPlaylist(String inteface, String place, Short idService) {
        boolean flag;
        Date now;
        if (inteface == null || place == null || References.getBanners() == null) {
            return null;
        }
        List<Banner> banners = Arrays.asList(References.getBanners());
        if (banners.isEmpty() || banners.size() == 1 && banners.get(0).getId() == 0) {
            return null;
        }
        LinkedList<Banner> targets = new LinkedList<Banner>();
        if (idService != null) {
            String servs;
            for (Banner banner : banners) {
                if (!inteface.equals(banner.getIface()) || !place.equals(banner.getPosition()) || banner.getId() <= 0 || !banner.isExclusive()) continue;
                now = new Date();
                if (banner.getBegin() != null && !now.after(banner.getBegin()) || banner.getEnd() != null && !now.before(banner.getEnd())) continue;
                if (banner.getServices() != null) {
                    servs = "," + banner.getServices() + ",";
                    if (!servs.contains("," + idService + ",")) continue;
                    targets.add(banner);
                    continue;
                }
                if (!idService.equals(banner.getIdService())) continue;
                targets.add(banner);
            }
            if (targets.isEmpty()) {
                for (Banner banner : banners) {
                    if (!inteface.equals(banner.getIface()) || !place.equals(banner.getPosition()) || banner.getId() <= 0) continue;
                    now = new Date();
                    if (banner.getBegin() != null && !now.after(banner.getBegin()) || banner.getEnd() != null && !now.before(banner.getEnd())) continue;
                    if (idService.equals(banner.getIdService())) {
                        targets.add(banner);
                        continue;
                    }
                    if (banner.getServices() == null || !(servs = "," + banner.getServices() + ",").contains("," + idService + ",")) continue;
                    targets.add(banner);
                }
            }
        } else {
            for (Banner banner : banners) {
                if (!inteface.equals(banner.getIface()) || !place.equals(banner.getPosition()) || banner.getId() <= 0) continue;
                now = new Date();
                if (banner.getBegin() != null && !now.after(banner.getBegin()) || banner.getEnd() != null && !now.before(banner.getEnd()) || banner.getIdService() != null) continue;
                targets.add(banner);
            }
        }
        if (targets.isEmpty()) {
            return null;
        }
        Collections.sort(targets, (o1, o2) -> o2.getWeight() - o1.getWeight());
        Map map = targets.stream().collect(Collectors.toMap(Function.identity(), Banner::getWeight));
        LinkedList<Banner> result = new LinkedList<Banner>();
        do {
            flag = false;
            for (Banner key : targets) {
                int val = map.get(key);
                if (val <= 0) continue;
                flag = true;
                result.add(key);
                map.put(key, val - 1);
            }
        } while (flag);
        return result;
    }

    private static List<Movie> getMoviePlaylist(Short idService) {
        boolean flag;
        Date now;
        if (References.getMovies() == null) {
            return null;
        }
        List<Movie> movies = Arrays.asList(References.getMovies());
        log.debug((Object)("All movies: " + movies));
        if (movies.isEmpty()) {
            return null;
        }
        LinkedList<Movie> targets = new LinkedList<Movie>();
        if (idService != null) {
            for (Movie movie : movies) {
                now = new Date();
                if (movie.getBegin() != null && !now.after(movie.getBegin()) || movie.getEnd() != null && !now.before(movie.getEnd()) || !idService.equals(movie.getIdService())) continue;
                targets.add(movie);
            }
        } else {
            for (Movie movie : movies) {
                log.debug((Object)("Process: " + movie));
                now = new Date();
                if (movie.getBegin() != null && !now.after(movie.getBegin()) || movie.getEnd() != null && !now.before(movie.getEnd())) continue;
                targets.add(movie);
            }
        }
        if (targets.isEmpty()) {
            return null;
        }
        Collections.sort(targets, (o1, o2) -> o2.getWeight() - o1.getWeight());
        log.debug((Object)("Sorted banners: " + targets));
        Map map = targets.stream().collect(Collectors.toMap(Function.identity(), Movie::getWeight));
        LinkedList<Movie> result = new LinkedList<Movie>();
        do {
            flag = false;
            for (Movie key : targets) {
                int val = map.get(key);
                if (val <= 0) continue;
                flag = true;
                result.add(key);
                map.put(key, val - 1);
            }
        } while (flag);
        log.debug((Object)("Result: " + result));
        return result;
    }
}

