/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.adv;

import fxterm.app.id.LoggerId;
import fxterm.core.adv.AdvDescription;
import fxterm.core.adv.AdvStore;
import fxterm.module.Module;
import fxterm.module.ModuleStore;
import fxterm.session.Session;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import plfx.GuiNotifier;
import plfx.adv.AdClickLisnener;
import plfx.adv.AdPlace;
import plfx.skin.Skin;
import plfx.util.TerminalPlatform;
import ru.softlogic.reference.service.Service;

public class AdvBannerRotator
implements Runnable {
    private final Logger log = LoggerId.ADV;
    private final List<AdPlace> places;

    public AdvBannerRotator(List<AdPlace> places) {
        this.places = Objects.requireNonNull(places, "Places is not set");
    }

    @Override
    public void run() {
        this.log.info((Object)"Start adv rotator");
        this.log.debug((Object)("Places: " + this.places));
        if (this.places.isEmpty()) {
            this.log.info((Object)"AdPlaces is not available. Stop adv rotator");
            return;
        }
        try {
            Service last = Session.getService();
            while (!Thread.currentThread().isInterrupted()) {
                Service curent = Session.getService();
                for (AdPlace place : this.places) {
                    if (place.getTimeLeft().get() == 0 || curent != last) {
                        this.log.debug((Object)("Process place: " + place.getId() + ", skin: " + Skin.getWorkSkin() + "."));
                        AdvDescription desc = null;
                        if (curent != null) {
                            this.log.debug((Object)"Trying to get exclusive banner");
                            desc = AdvStore.getNextBanner(place.getId(), Session.getService().getId());
                        }
                        if (desc == null) {
                            this.log.debug((Object)"Getting common banner");
                            desc = AdvStore.getNextBanner(place.getId(), null);
                        }
                        if (desc != null) {
                            place.getTimeLeft().set(Optional.ofNullable(desc.getShowTime()).orElse(60) * 10);
                            TerminalPlatform.runLater((Runnable)new UpdateBanner(desc, place));
                        } else {
                            place.getTimeLeft().set(10);
                            TerminalPlatform.runLater(() -> place.showContent(null, null, null));
                        }
                    }
                    place.getTimeLeft().decrementAndGet();
                }
                last = curent;
                TimeUnit.MILLISECONDS.sleep(100L);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        this.log.info((Object)"Stop adv rotator");
    }

    private class ClickHandler
    implements AdClickLisnener {
        private final AdvDescription desc;
        private final AdPlace place;

        public ClickHandler(AdvDescription desc, AdPlace place) {
            this.desc = desc;
            this.place = place;
        }

        public void onClick() {
            Module m = ModuleStore.getModule();
            try {
                if (m != null) {
                    m.onBannerClicked(this.desc.getBanner());
                }
            }
            catch (Throwable ex) {
                AdvBannerRotator.this.log.error((Object)("" + this.place + "," + this.desc + "," + m));
                GuiNotifier.notifyError((Throwable)ex);
            }
        }
    }

    private class UpdateBanner
    implements Runnable {
        private final AdvDescription desc;
        private final AdPlace place;

        public UpdateBanner(AdvDescription desc, AdPlace place) {
            this.desc = desc;
            this.place = place;
        }

        @Override
        public void run() {
            try {
                this.place.showContent(this.desc.getPath(), this.desc.getContentType(), (AdClickLisnener)new ClickHandler(this.desc, this.place));
            }
            catch (Throwable ex) {
                AdvBannerRotator.this.log.error((Object)("" + this.place + "," + this.desc));
                GuiNotifier.notifyError((Throwable)ex);
            }
        }
    }
}

