/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.adv;

import fxterm.app.id.LoggerId;
import fxterm.core.adv.AdvDescription;
import fxterm.core.adv.AdvStore;
import fxterm.module.Module;
import fxterm.module.ModuleStore;
import fxterm.session.Session;
import java.util.Optional;
import org.apache.log4j.Logger;
import plfx.GuiNotifier;
import plfx.adv.AdClickLisnener;
import plfx.adv.AdPlace;
import plfx.screen.FxScreenTemplate;
import plfx.shell.BannerProcessor;

public class AdvBannerProcessor
implements BannerProcessor {
    private final Logger log = LoggerId.ADV;

    public void process(FxScreenTemplate template) {
        if (template == null || template.getAdPlaces() == null || template.getAdPlaces().isEmpty()) {
            return;
        }
        this.log.info((Object)("Process screen: " + template.getId()));
        for (AdPlace place : template.getAdPlaces()) {
            this.log.info((Object)("Process place: " + place.getId()));
            AdvDescription desc = null;
            if (Session.getService() != null) {
                this.log.info((Object)"Trying to get exclusive banner");
                desc = AdvStore.getNextBanner(place.getId(), Session.getService().getId());
            }
            if (desc == null) {
                this.log.info((Object)"Getting common banner");
                desc = AdvStore.getNextBanner(place.getId(), null);
            }
            this.log.info((Object)("Get desc: " + desc));
            if (desc != null) {
                place.getTimeLeft().set(Optional.ofNullable(desc.getShowTime()).orElse(60));
                place.showContent(desc.getPath(), desc.getContentType(), (AdClickLisnener)new ClickHandler(desc, place));
                continue;
            }
            place.getTimeLeft().set(1);
            place.showContent(null, null, null);
        }
        this.log.info((Object)"---");
    }

    public void update(FxScreenTemplate template) {
        if (template == null || template.getAdPlaces() == null || template.getAdPlaces().isEmpty()) {
            return;
        }
        for (AdPlace place : template.getAdPlaces()) {
            if (place.getTimeLeft().get() == 0) {
                AdvDescription desc = null;
                if (Session.getService() != null) {
                    desc = AdvStore.getNextBanner(place.getId(), Session.getService().getId());
                }
                if (desc == null) {
                    desc = AdvStore.getNextBanner(place.getId(), null);
                }
                if (desc != null) {
                    this.log.info((Object)("Get new desc: " + desc + ", screen: " + template.getId() + ", place: " + place.getId()));
                    place.getTimeLeft().set(Optional.ofNullable(desc.getShowTime()).orElse(60));
                    place.showContent(desc.getPath(), desc.getContentType(), (AdClickLisnener)new ClickHandler(desc, place));
                } else {
                    place.getTimeLeft().set(1);
                    place.showContent(null, null, null);
                }
            }
            place.getTimeLeft().decrementAndGet();
        }
    }

    private class ClickHandler
    implements AdClickLisnener {
        private final AdvDescription desc;
        private final AdPlace place;

        public ClickHandler(AdvDescription desc, AdPlace place) {
            this.desc = desc;
            this.place = place;
        }

        public void onClick() {
            Module m = ModuleStore.getModule();
            try {
                if (m != null) {
                    m.onBannerClicked(this.desc.getBanner());
                }
            }
            catch (Throwable ex) {
                AdvBannerProcessor.this.log.error((Object)("" + this.place + "," + this.desc + "," + m));
                GuiNotifier.notifyError((Throwable)ex);
            }
        }
    }
}

