/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.activity;

import fxterm.app.id.LoggerId;
import fxterm.core.activity.UserAction;
import fxterm.core.task.StateListener;
import org.apache.log4j.Logger;

public class TaskStateMonitor
implements StateListener,
Runnable {
    private UserAction userAction;
    private boolean active;
    private final Logger log = LoggerId.DEBUG;

    public TaskStateMonitor(UserAction userAction) {
        if (userAction == null) {
            throw new NullPointerException("UserAction");
        }
        this.userAction = userAction;
    }

    @Override
    public synchronized void onStart() {
        this.log.info((Object)"TaskStateMonitor: onStart");
        this.active = true;
        this.notifyAll();
    }

    @Override
    public synchronized void onComplete() {
        this.log.info((Object)"TaskStateMonitor: onComplete");
        this.active = false;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.log.info((Object)"Start thread");
        try {
            while (!Thread.currentThread().isInterrupted()) {
                TaskStateMonitor taskStateMonitor = this;
                synchronized (taskStateMonitor) {
                    if (!this.active) {
                        this.wait();
                    } else {
                        this.wait(5000L);
                    }
                }
                this.log.info((Object)"Update user action");
                this.userAction.update();
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        this.log.info((Object)"Stop thread");
    }
}

