/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core;

import fxterm.app.id.LoggerId;
import fxterm.core.reboot.SafeReboot;
import org.apache.log4j.Logger;
import plfx.skin.Skin;
import ru.softlogic.reference.ReferenceData;
import ru.softlogic.reference.References;
import ru.softlogic.reference.ReferencesListener;

public class SkinUpdater
implements ReferencesListener {
    private final Logger log = LoggerId.APP;
    private boolean first = true;
    private String skin;
    private String colorScheme;

    public SkinUpdater() {
        if (References.getVersion() > 0L) {
            this.skin = References.getMenu().getIface();
            this.colorScheme = References.getMenu().getMenuDesign();
            this.first = false;
            this.log.info((Object)("Skin set to " + this.skin));
            this.log.info((Object)("Color scheme set to " + this.colorScheme));
        }
    }

    public void onReferences(ReferenceData data) {
        if (this.first) {
            this.skin = Skin.getWorkSkin();
            this.colorScheme = Skin.getWorkColorScheme();
            this.first = false;
            this.log.info((Object)("Skin set to " + this.skin));
            this.log.info((Object)("Color scheme set to " + this.colorScheme));
        }
        boolean reboot = false;
        if (!this.skin.equals(data.getMenu().getIface())) {
            if (Skin.getWorkSkin() != null && Skin.getWorkSkin().equals(data.getMenu().getIface())) {
                this.log.info((Object)("Skin changed from " + this.skin + " to " + data.getMenu().getIface() + ". Skip reboot because skin is already installed"));
                this.skin = data.getMenu().getIface();
            } else if (!Skin.isExistSkin((String)data.getMenu().getIface())) {
                this.log.info((Object)("Skin changed from " + this.skin + " to " + data.getMenu().getIface() + ", but this skin is not exist. Skip reboot command"));
            } else {
                this.log.info((Object)("Skin changed from " + this.skin + " to " + data.getMenu().getIface() + ". Add reboot command"));
                reboot = true;
            }
        }
        if (reboot) {
            SafeReboot.exit(0, 12);
            return;
        }
        if (this.colorScheme == null && data.getMenu().getMenuDesign() != null || this.colorScheme != null && data.getMenu().getMenuDesign() == null || this.colorScheme != null && data.getMenu().getMenuDesign() != null && !this.colorScheme.equals(data.getMenu().getMenuDesign())) {
            if (Skin.isExistColorScheme((String)data.getMenu().getMenuDesign())) {
                this.log.info((Object)("Color scheme changed from " + this.colorScheme + " to " + data.getMenu().getMenuDesign() + ". Add reboot command"));
                reboot = true;
            } else {
                this.log.info((Object)("Color scheme changed from " + this.colorScheme + " to " + data.getMenu().getMenuDesign() + ", but this scheme is not exist. Skip reboot command"));
            }
        }
        if (reboot) {
            SafeReboot.exit(0, 12);
        }
    }
}

