/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core;

import fxterm.app.id.LoggerId;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import plfx.util.LocatorErrorListener;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.srv.connector.ClientInterface;

public class ResourceErrorListener
implements LocatorErrorListener {
    private final Logger log = LoggerId.START;
    private final Set<String> set = new HashSet<String>();
    private ClientInterface client;

    public ResourceErrorListener(ClientInterface client) {
        if (client == null) {
            throw new NullPointerException("ClientInterface");
        }
        this.client = client;
    }

    public void onMissingResource(String resourceId, String searchPath) {
        if (resourceId != null && !this.set.contains(resourceId)) {
            this.set.add(resourceId);
            this.log.error((Object)("Can't find " + resourceId + " on path " + searchPath));
            this.client.sendEvent(new Event[]{new Event(EventType.Warning, "Missing resource " + searchPath)});
        }
    }
}

